/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCategory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCategoryCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceCategoryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCategoryRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCategoryCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceCategoryCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceCategoryCollectionRequest;
import java.util.List;

public class BaseDeviceCategoryCollectionRequest
extends BaseCollectionRequest<BaseDeviceCategoryCollectionResponse, IDeviceCategoryCollectionPage>
implements IBaseDeviceCategoryCollectionRequest {
    public BaseDeviceCategoryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceCategoryCollectionResponse.class, IDeviceCategoryCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCategoryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceCategoryCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCategoryCollectionPage get() throws ClientException {
        BaseDeviceCategoryCollectionResponse response = (BaseDeviceCategoryCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCategory newDeviceCategory, ICallback<DeviceCategory> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCategory, callback);
    }

    @Override
    public DeviceCategory post(DeviceCategory newDeviceCategory) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCategoryRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCategory);
    }

    @Override
    public IDeviceCategoryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceCategoryCollectionRequest)this;
    }

    @Override
    public IDeviceCategoryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceCategoryCollectionRequest)this;
    }

    @Override
    public IDeviceCategoryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceCategoryCollectionRequest)this;
    }

    public IDeviceCategoryCollectionPage buildFromResponse(BaseDeviceCategoryCollectionResponse response) {
        DeviceCategoryCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCategoryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCategoryCollectionPage page = new DeviceCategoryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

