/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Contact;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContactCollectionPage;
import com.microsoft.graph.requests.extensions.ContactCollectionRequest;
import com.microsoft.graph.requests.extensions.ContactCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactCollectionPage;
import com.microsoft.graph.requests.extensions.IContactCollectionRequest;
import com.microsoft.graph.requests.generated.BaseContactCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseContactCollectionRequest;
import java.util.List;

public class BaseContactCollectionRequest
extends BaseCollectionRequest<BaseContactCollectionResponse, IContactCollectionPage>
implements IBaseContactCollectionRequest {
    public BaseContactCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseContactCollectionResponse.class, IContactCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContactCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseContactCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContactCollectionPage get() throws ClientException {
        BaseContactCollectionResponse response = (BaseContactCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Contact newContact, ICallback<Contact> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContact, callback);
    }

    @Override
    public Contact post(Contact newContact) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newContact);
    }

    @Override
    public IContactCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ContactCollectionRequest)this;
    }

    @Override
    public IContactCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ContactCollectionRequest)this;
    }

    @Override
    public IContactCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ContactCollectionRequest)this;
    }

    public IContactCollectionPage buildFromResponse(BaseContactCollectionResponse response) {
        ContactCollectionRequestBuilder builder = response.nextLink != null ? new ContactCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContactCollectionPage page = new ContactCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

