/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookPivotTable;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookPivotTableCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookPivotTableCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookPivotTableCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookPivotTableCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookPivotTableCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookPivotTableRequestBuilder;
import com.microsoft.graph.requests.generated.BaseWorkbookPivotTableCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseWorkbookPivotTableCollectionRequest;
import java.util.List;

public class BaseWorkbookPivotTableCollectionRequest
extends BaseCollectionRequest<BaseWorkbookPivotTableCollectionResponse, IWorkbookPivotTableCollectionPage>
implements IBaseWorkbookPivotTableCollectionRequest {
    public BaseWorkbookPivotTableCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookPivotTableCollectionResponse.class, IWorkbookPivotTableCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookPivotTableCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookPivotTableCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookPivotTableCollectionPage get() throws ClientException {
        BaseWorkbookPivotTableCollectionResponse response = (BaseWorkbookPivotTableCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookPivotTable newWorkbookPivotTable, ICallback<WorkbookPivotTable> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookPivotTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookPivotTable, callback);
    }

    @Override
    public WorkbookPivotTable post(WorkbookPivotTable newWorkbookPivotTable) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookPivotTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookPivotTable);
    }

    @Override
    public IWorkbookPivotTableCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    @Override
    public IWorkbookPivotTableCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    @Override
    public IWorkbookPivotTableCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    public IWorkbookPivotTableCollectionPage buildFromResponse(BaseWorkbookPivotTableCollectionResponse response) {
        WorkbookPivotTableCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookPivotTableCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookPivotTableCollectionPage page = new WorkbookPivotTableCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

