/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.VppToken;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IVppTokenCollectionPage;
import com.microsoft.graph.requests.extensions.IVppTokenCollectionRequest;
import com.microsoft.graph.requests.extensions.VppTokenCollectionPage;
import com.microsoft.graph.requests.extensions.VppTokenCollectionRequest;
import com.microsoft.graph.requests.extensions.VppTokenCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.VppTokenRequestBuilder;
import com.microsoft.graph.requests.generated.BaseVppTokenCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseVppTokenCollectionRequest;
import java.util.List;

public class BaseVppTokenCollectionRequest
extends BaseCollectionRequest<BaseVppTokenCollectionResponse, IVppTokenCollectionPage>
implements IBaseVppTokenCollectionRequest {
    public BaseVppTokenCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseVppTokenCollectionResponse.class, IVppTokenCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IVppTokenCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseVppTokenCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IVppTokenCollectionPage get() throws ClientException {
        BaseVppTokenCollectionResponse response = (BaseVppTokenCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(VppToken newVppToken, ICallback<VppToken> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newVppToken, callback);
    }

    @Override
    public VppToken post(VppToken newVppToken) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newVppToken);
    }

    @Override
    public IVppTokenCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (VppTokenCollectionRequest)this;
    }

    @Override
    public IVppTokenCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (VppTokenCollectionRequest)this;
    }

    @Override
    public IVppTokenCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (VppTokenCollectionRequest)this;
    }

    public IVppTokenCollectionPage buildFromResponse(BaseVppTokenCollectionResponse response) {
        VppTokenCollectionRequestBuilder builder = response.nextLink != null ? new VppTokenCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        VppTokenCollectionPage page = new VppTokenCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

