/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppContent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppContentCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppContentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileAppContentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileAppContentCollectionRequest;
import java.util.List;

public class BaseMobileAppContentCollectionRequest
extends BaseCollectionRequest<BaseMobileAppContentCollectionResponse, IMobileAppContentCollectionPage>
implements IBaseMobileAppContentCollectionRequest {
    public BaseMobileAppContentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileAppContentCollectionResponse.class, IMobileAppContentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppContentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMobileAppContentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppContentCollectionPage get() throws ClientException {
        BaseMobileAppContentCollectionResponse response = (BaseMobileAppContentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppContent newMobileAppContent, ICallback<MobileAppContent> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContent, callback);
    }

    @Override
    public MobileAppContent post(MobileAppContent newMobileAppContent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContent);
    }

    @Override
    public IMobileAppContentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileAppContentCollectionRequest)this;
    }

    @Override
    public IMobileAppContentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileAppContentCollectionRequest)this;
    }

    @Override
    public IMobileAppContentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppContentCollectionRequest)this;
    }

    public IMobileAppContentCollectionPage buildFromResponse(BaseMobileAppContentCollectionResponse response) {
        MobileAppContentCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppContentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppContentCollectionPage page = new MobileAppContentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

