/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Message;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMessageCollectionPage;
import com.microsoft.graph.requests.extensions.IMessageCollectionRequest;
import com.microsoft.graph.requests.extensions.MessageCollectionPage;
import com.microsoft.graph.requests.extensions.MessageCollectionRequest;
import com.microsoft.graph.requests.extensions.MessageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MessageRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMessageCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMessageCollectionRequest;
import java.util.List;

public class BaseMessageCollectionRequest
extends BaseCollectionRequest<BaseMessageCollectionResponse, IMessageCollectionPage>
implements IBaseMessageCollectionRequest {
    public BaseMessageCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMessageCollectionResponse.class, IMessageCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMessageCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMessageCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMessageCollectionPage get() throws ClientException {
        BaseMessageCollectionResponse response = (BaseMessageCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Message newMessage, ICallback<Message> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessage, callback);
    }

    @Override
    public Message post(Message newMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessage);
    }

    @Override
    public IMessageCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MessageCollectionRequest)this;
    }

    @Override
    public IMessageCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MessageCollectionRequest)this;
    }

    @Override
    public IMessageCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MessageCollectionRequest)this;
    }

    public IMessageCollectionPage buildFromResponse(BaseMessageCollectionResponse response) {
        MessageCollectionRequestBuilder builder = response.nextLink != null ? new MessageCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MessageCollectionPage page = new MessageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

