/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IManagedAppRegistrationCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedAppRegistrationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedAppRegistrationCollectionWithReferencesRequest;
import java.util.List;

public class BaseManagedAppRegistrationCollectionWithReferencesRequest
extends BaseCollectionRequest<BaseManagedAppRegistrationCollectionResponse, IManagedAppRegistrationCollectionPage>
implements IBaseManagedAppRegistrationCollectionWithReferencesRequest {
    public BaseManagedAppRegistrationCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedAppRegistrationCollectionResponse.class, IManagedAppRegistrationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppRegistrationCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedAppRegistrationCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppRegistrationCollectionWithReferencesPage get() throws ClientException {
        BaseManagedAppRegistrationCollectionResponse response = (BaseManagedAppRegistrationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IManagedAppRegistrationCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedAppRegistrationCollectionWithReferencesRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedAppRegistrationCollectionWithReferencesRequest)this;
    }

    @Override
    public IManagedAppRegistrationCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedAppRegistrationCollectionWithReferencesRequest)this;
    }

    public IManagedAppRegistrationCollectionWithReferencesPage buildFromResponse(BaseManagedAppRegistrationCollectionResponse response) {
        ManagedAppRegistrationCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ManagedAppRegistrationCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppRegistrationCollectionWithReferencesPage page = new ManagedAppRegistrationCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

