/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.LicenseDetails;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ILicenseDetailsCollectionPage;
import com.microsoft.graph.requests.extensions.ILicenseDetailsCollectionRequest;
import com.microsoft.graph.requests.extensions.LicenseDetailsCollectionPage;
import com.microsoft.graph.requests.extensions.LicenseDetailsCollectionRequest;
import com.microsoft.graph.requests.extensions.LicenseDetailsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.LicenseDetailsRequestBuilder;
import com.microsoft.graph.requests.generated.BaseLicenseDetailsCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseLicenseDetailsCollectionRequest;
import java.util.List;

public class BaseLicenseDetailsCollectionRequest
extends BaseCollectionRequest<BaseLicenseDetailsCollectionResponse, ILicenseDetailsCollectionPage>
implements IBaseLicenseDetailsCollectionRequest {
    public BaseLicenseDetailsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseLicenseDetailsCollectionResponse.class, ILicenseDetailsCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ILicenseDetailsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseLicenseDetailsCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ILicenseDetailsCollectionPage get() throws ClientException {
        BaseLicenseDetailsCollectionResponse response = (BaseLicenseDetailsCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(LicenseDetails newLicenseDetails, ICallback<LicenseDetails> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new LicenseDetailsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLicenseDetails, callback);
    }

    @Override
    public LicenseDetails post(LicenseDetails newLicenseDetails) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LicenseDetailsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLicenseDetails);
    }

    @Override
    public ILicenseDetailsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (LicenseDetailsCollectionRequest)this;
    }

    @Override
    public ILicenseDetailsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (LicenseDetailsCollectionRequest)this;
    }

    @Override
    public ILicenseDetailsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (LicenseDetailsCollectionRequest)this;
    }

    public ILicenseDetailsCollectionPage buildFromResponse(BaseLicenseDetailsCollectionResponse response) {
        LicenseDetailsCollectionRequestBuilder builder = response.nextLink != null ? new LicenseDetailsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        LicenseDetailsCollectionPage page = new LicenseDetailsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

