/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationAssignBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationAssignCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationAssignCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceConfigurationAssignCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceConfigurationAssignCollectionRequest;
import java.util.List;

public class BaseDeviceConfigurationAssignCollectionRequest
extends BaseCollectionRequest<BaseDeviceConfigurationAssignCollectionResponse, IDeviceConfigurationAssignCollectionPage>
implements IBaseDeviceConfigurationAssignCollectionRequest {
    protected final DeviceConfigurationAssignBody body = new DeviceConfigurationAssignBody();

    public BaseDeviceConfigurationAssignCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceConfigurationAssignCollectionResponse.class, IDeviceConfigurationAssignCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IDeviceConfigurationAssignCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceConfigurationAssignCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationAssignCollectionPage post() throws ClientException {
        BaseDeviceConfigurationAssignCollectionResponse response = (BaseDeviceConfigurationAssignCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDeviceConfigurationAssignCollectionPage buildFromResponse(BaseDeviceConfigurationAssignCollectionResponse response) {
        DeviceConfigurationAssignCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationAssignCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DeviceConfigurationAssignCollectionPage page = new DeviceConfigurationAssignCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDeviceConfigurationAssignCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDeviceConfigurationAssignCollectionRequest)((Object)this);
    }

    @Override
    public IDeviceConfigurationAssignCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDeviceConfigurationAssignCollectionRequest)((Object)this);
    }

    @Override
    public IDeviceConfigurationAssignCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDeviceConfigurationAssignCollectionRequest)((Object)this);
    }
}

