/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceSettingState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceSettingStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceSettingStateCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceComplianceSettingStateCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceComplianceSettingStateCollectionRequest;
import java.util.List;

public class BaseDeviceComplianceSettingStateCollectionRequest
extends BaseCollectionRequest<BaseDeviceComplianceSettingStateCollectionResponse, IDeviceComplianceSettingStateCollectionPage>
implements IBaseDeviceComplianceSettingStateCollectionRequest {
    public BaseDeviceComplianceSettingStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceComplianceSettingStateCollectionResponse.class, IDeviceComplianceSettingStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceSettingStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceComplianceSettingStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceSettingStateCollectionPage get() throws ClientException {
        BaseDeviceComplianceSettingStateCollectionResponse response = (BaseDeviceComplianceSettingStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceSettingState newDeviceComplianceSettingState, ICallback<DeviceComplianceSettingState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceSettingState, callback);
    }

    @Override
    public DeviceComplianceSettingState post(DeviceComplianceSettingState newDeviceComplianceSettingState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceSettingStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceSettingState);
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceComplianceSettingStateCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceComplianceSettingStateCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceSettingStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceComplianceSettingStateCollectionRequest)this;
    }

    public IDeviceComplianceSettingStateCollectionPage buildFromResponse(BaseDeviceComplianceSettingStateCollectionResponse response) {
        DeviceComplianceSettingStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceSettingStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceSettingStateCollectionPage page = new DeviceComplianceSettingStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

