/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceActionItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceActionItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceActionItemCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceActionItemCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceComplianceActionItemCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceComplianceActionItemCollectionRequest;
import java.util.List;

public class BaseDeviceComplianceActionItemCollectionRequest
extends BaseCollectionRequest<BaseDeviceComplianceActionItemCollectionResponse, IDeviceComplianceActionItemCollectionPage>
implements IBaseDeviceComplianceActionItemCollectionRequest {
    public BaseDeviceComplianceActionItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceComplianceActionItemCollectionResponse.class, IDeviceComplianceActionItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceActionItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceComplianceActionItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceActionItemCollectionPage get() throws ClientException {
        BaseDeviceComplianceActionItemCollectionResponse response = (BaseDeviceComplianceActionItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceActionItem newDeviceComplianceActionItem, ICallback<DeviceComplianceActionItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceActionItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceActionItem, callback);
    }

    @Override
    public DeviceComplianceActionItem post(DeviceComplianceActionItem newDeviceComplianceActionItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceActionItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceActionItem);
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceComplianceActionItemCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceComplianceActionItemCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceActionItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceComplianceActionItemCollectionRequest)this;
    }

    public IDeviceComplianceActionItemCollectionPage buildFromResponse(BaseDeviceComplianceActionItemCollectionResponse response) {
        DeviceComplianceActionItemCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceActionItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceActionItemCollectionPage page = new DeviceComplianceActionItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

