/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Alert;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AlertCollectionPage;
import com.microsoft.graph.requests.extensions.AlertCollectionRequest;
import com.microsoft.graph.requests.extensions.AlertCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AlertRequestBuilder;
import com.microsoft.graph.requests.extensions.IAlertCollectionPage;
import com.microsoft.graph.requests.extensions.IAlertCollectionRequest;
import com.microsoft.graph.requests.generated.BaseAlertCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseAlertCollectionRequest;
import java.util.List;

public class BaseAlertCollectionRequest
extends BaseCollectionRequest<BaseAlertCollectionResponse, IAlertCollectionPage>
implements IBaseAlertCollectionRequest {
    public BaseAlertCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseAlertCollectionResponse.class, IAlertCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAlertCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseAlertCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAlertCollectionPage get() throws ClientException {
        BaseAlertCollectionResponse response = (BaseAlertCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Alert newAlert, ICallback<Alert> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newAlert, callback);
    }

    @Override
    public Alert post(Alert newAlert) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newAlert);
    }

    @Override
    public IAlertCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (AlertCollectionRequest)this;
    }

    @Override
    public IAlertCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (AlertCollectionRequest)this;
    }

    @Override
    public IAlertCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (AlertCollectionRequest)this;
    }

    public IAlertCollectionPage buildFromResponse(BaseAlertCollectionResponse response) {
        AlertCollectionRequestBuilder builder = response.nextLink != null ? new AlertCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AlertCollectionPage page = new AlertCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

