/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.BaseItem;
import com.microsoft.graph.models.extensions.ContentTypeInfo;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.FieldValueSet;
import com.microsoft.graph.models.extensions.ListItemVersion;
import com.microsoft.graph.models.extensions.SharepointIds;
import com.microsoft.graph.requests.extensions.ListItemVersionCollectionPage;
import com.microsoft.graph.requests.generated.BaseListItemVersionCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class BaseListItem
extends BaseItem
implements IJsonBackedObject {
    @SerializedName(value="contentType")
    @Expose
    public ContentTypeInfo contentType;
    @SerializedName(value="sharepointIds")
    @Expose
    public SharepointIds sharepointIds;
    @SerializedName(value="driveItem")
    @Expose
    public DriveItem driveItem;
    @SerializedName(value="fields")
    @Expose
    public FieldValueSet fields;
    public ListItemVersionCollectionPage versions;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("versions")) {
            BaseListItemVersionCollectionResponse response = new BaseListItemVersionCollectionResponse();
            if (json.has("versions@odata.nextLink")) {
                response.nextLink = json.get("versions@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("versions").toString(), JsonObject[].class);
            ListItemVersion[] array = new ListItemVersion[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ListItemVersion.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.versions = new ListItemVersionCollectionPage(response, null);
        }
    }
}

