/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonElement;
import com.microsoft.graph.models.extensions.PlannerExternalReference;
import com.microsoft.graph.models.generated.BasePlannerExternalReferences;
import com.microsoft.graph.serializer.ISerializer;
import java.security.InvalidParameterException;

public class PlannerExternalReferences
extends BasePlannerExternalReferences {
    private static String[][] conversions = new String[][]{{"%", "%25"}, {"@", "%40"}, {".", "%2E"}, {":", "%3A"}};

    public PlannerExternalReference reference(String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidParameterException("URL cannot be empty");
        }
        if (this.additionalDataManager().containsKey(PlannerExternalReferences.encode(url))) {
            JsonElement refObject = (JsonElement)this.additionalDataManager().get(PlannerExternalReferences.encode(url));
            ISerializer serializer = this.getSerializer();
            return serializer.deserializeObject(refObject.getAsString(), PlannerExternalReference.class);
        }
        return null;
    }

    public PlannerExternalReference addReference(String url, String alias) {
        if (url == null || url.isEmpty()) {
            throw new InvalidParameterException("URL cannot be empty");
        }
        if (alias == null || alias.isEmpty()) {
            throw new InvalidParameterException("Alias cannot be empty");
        }
        PlannerExternalReference plannerExternalReference = new PlannerExternalReference();
        plannerExternalReference.alias = alias;
        this.additionalDataManager().put(PlannerExternalReferences.encode(url), plannerExternalReference.getRawObject());
        return plannerExternalReference;
    }

    private static String encode(String externalReferenceUrl) {
        if (externalReferenceUrl == null || externalReferenceUrl.isEmpty()) {
            throw new InvalidParameterException("URL cannot be empty");
        }
        for (int i = 0; i < conversions.length; ++i) {
            externalReferenceUrl = externalReferenceUrl.replace(conversions[i][0], conversions[i][1]);
        }
        return externalReferenceUrl;
    }

    private static String decode(String externalReferenceUrl) {
        if (externalReferenceUrl == null || externalReferenceUrl.isEmpty()) {
            throw new InvalidParameterException("URL cannot be empty");
        }
        for (int i = conversions.length - 1; i >= 0; --i) {
            externalReferenceUrl = externalReferenceUrl.replace(conversions[i][1], conversions[i][0]);
        }
        return externalReferenceUrl;
    }
}

