package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

/**
 * The scheduling priority options for downloading and preparing the requested mac OS update
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public enum MacOSPriority implements ValuedEnum {
    /** Indicates low scheduling priority for downloading and preparing the requested update */
    Low("low"),
    /** Indicates high scheduling priority for downloading and preparing the requested update */
    High("high"),
    /** Evolvable enumeration sentinel value. Do not use. */
    UnknownFutureValue("unknownFutureValue");
    public final String value;
    MacOSPriority(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static MacOSPriority forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "low": return Low;
            case "high": return High;
            case "unknownFutureValue": return UnknownFutureValue;
            default: return null;
        }
    }
}
