package com.microsoft.graph.beta.models.security;

import com.microsoft.graph.beta.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class Vulnerability extends Entity implements Parsable {
    /**
     * Instantiates a new {@link Vulnerability} and sets the default values.
     */
    public Vulnerability() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link Vulnerability}
     */
    @jakarta.annotation.Nonnull
    public static Vulnerability createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Vulnerability();
    }
    /**
     * Gets the activeExploitsObserved property value. Indicates whether this vulnerability has any known exploits associated to known bad actors.
     * @return a {@link Boolean}
     */
    @jakarta.annotation.Nullable
    public Boolean getActiveExploitsObserved() {
        return this.backingStore.get("activeExploitsObserved");
    }
    /**
     * Gets the articles property value. Articles related to this vulnerability.
     * @return a {@link java.util.List<Article>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<Article> getArticles() {
        return this.backingStore.get("articles");
    }
    /**
     * Gets the commonWeaknessEnumerationIds property value. Community-defined common weakness enumerations (CWE).
     * @return a {@link java.util.List<String>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getCommonWeaknessEnumerationIds() {
        return this.backingStore.get("commonWeaknessEnumerationIds");
    }
    /**
     * Gets the components property value. Components related to this vulnerability article.
     * @return a {@link java.util.List<VulnerabilityComponent>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<VulnerabilityComponent> getComponents() {
        return this.backingStore.get("components");
    }
    /**
     * Gets the createdDateTime property value. The date and time when this vulnerability article was first created.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getCreatedDateTime() {
        return this.backingStore.get("createdDateTime");
    }
    /**
     * Gets the cvss2Summary property value. The cvss2Summary property
     * @return a {@link CvssSummary}
     */
    @jakarta.annotation.Nullable
    public CvssSummary getCvss2Summary() {
        return this.backingStore.get("cvss2Summary");
    }
    /**
     * Gets the cvss3Summary property value. The cvss3Summary property
     * @return a {@link CvssSummary}
     */
    @jakarta.annotation.Nullable
    public CvssSummary getCvss3Summary() {
        return this.backingStore.get("cvss3Summary");
    }
    /**
     * Gets the description property value. The description property
     * @return a {@link FormattedContent}
     */
    @jakarta.annotation.Nullable
    public FormattedContent getDescription() {
        return this.backingStore.get("description");
    }
    /**
     * Gets the exploits property value. Known exploits for this vulnerability.
     * @return a {@link java.util.List<Hyperlink>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<Hyperlink> getExploits() {
        return this.backingStore.get("exploits");
    }
    /**
     * Gets the exploitsAvailable property value. Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
     * @return a {@link Boolean}
     */
    @jakarta.annotation.Nullable
    public Boolean getExploitsAvailable() {
        return this.backingStore.get("exploitsAvailable");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activeExploitsObserved", (n) -> { this.setActiveExploitsObserved(n.getBooleanValue()); });
        deserializerMap.put("articles", (n) -> { this.setArticles(n.getCollectionOfObjectValues(Article::createFromDiscriminatorValue)); });
        deserializerMap.put("commonWeaknessEnumerationIds", (n) -> { this.setCommonWeaknessEnumerationIds(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("components", (n) -> { this.setComponents(n.getCollectionOfObjectValues(VulnerabilityComponent::createFromDiscriminatorValue)); });
        deserializerMap.put("createdDateTime", (n) -> { this.setCreatedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("cvss2Summary", (n) -> { this.setCvss2Summary(n.getObjectValue(CvssSummary::createFromDiscriminatorValue)); });
        deserializerMap.put("cvss3Summary", (n) -> { this.setCvss3Summary(n.getObjectValue(CvssSummary::createFromDiscriminatorValue)); });
        deserializerMap.put("description", (n) -> { this.setDescription(n.getObjectValue(FormattedContent::createFromDiscriminatorValue)); });
        deserializerMap.put("exploits", (n) -> { this.setExploits(n.getCollectionOfObjectValues(Hyperlink::createFromDiscriminatorValue)); });
        deserializerMap.put("exploitsAvailable", (n) -> { this.setExploitsAvailable(n.getBooleanValue()); });
        deserializerMap.put("hasChatter", (n) -> { this.setHasChatter(n.getBooleanValue()); });
        deserializerMap.put("lastModifiedDateTime", (n) -> { this.setLastModifiedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("priorityScore", (n) -> { this.setPriorityScore(n.getIntegerValue()); });
        deserializerMap.put("publishedDateTime", (n) -> { this.setPublishedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("references", (n) -> { this.setReferences(n.getCollectionOfObjectValues(Hyperlink::createFromDiscriminatorValue)); });
        deserializerMap.put("remediation", (n) -> { this.setRemediation(n.getObjectValue(FormattedContent::createFromDiscriminatorValue)); });
        deserializerMap.put("severity", (n) -> { this.setSeverity(n.getEnumValue(VulnerabilitySeverity::forValue)); });
        return deserializerMap;
    }
    /**
     * Gets the hasChatter property value. Indicates whether chatter about this vulnerability has been discovered online.
     * @return a {@link Boolean}
     */
    @jakarta.annotation.Nullable
    public Boolean getHasChatter() {
        return this.backingStore.get("hasChatter");
    }
    /**
     * Gets the lastModifiedDateTime property value. The date and time when this vulnerability article was most recently updated.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return this.backingStore.get("lastModifiedDateTime");
    }
    /**
     * Gets the priorityScore property value. A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getPriorityScore() {
        return this.backingStore.get("priorityScore");
    }
    /**
     * Gets the publishedDateTime property value. The date and time when this vulnerability article was published.
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getPublishedDateTime() {
        return this.backingStore.get("publishedDateTime");
    }
    /**
     * Gets the references property value. Reference links where further information can be learned about this vulnerability.
     * @return a {@link java.util.List<Hyperlink>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<Hyperlink> getReferences() {
        return this.backingStore.get("references");
    }
    /**
     * Gets the remediation property value. Any known remediation steps.
     * @return a {@link FormattedContent}
     */
    @jakarta.annotation.Nullable
    public FormattedContent getRemediation() {
        return this.backingStore.get("remediation");
    }
    /**
     * Gets the severity property value. The severity property
     * @return a {@link VulnerabilitySeverity}
     */
    @jakarta.annotation.Nullable
    public VulnerabilitySeverity getSeverity() {
        return this.backingStore.get("severity");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("activeExploitsObserved", this.getActiveExploitsObserved());
        writer.writeCollectionOfObjectValues("articles", this.getArticles());
        writer.writeCollectionOfPrimitiveValues("commonWeaknessEnumerationIds", this.getCommonWeaknessEnumerationIds());
        writer.writeCollectionOfObjectValues("components", this.getComponents());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("cvss2Summary", this.getCvss2Summary());
        writer.writeObjectValue("cvss3Summary", this.getCvss3Summary());
        writer.writeObjectValue("description", this.getDescription());
        writer.writeCollectionOfObjectValues("exploits", this.getExploits());
        writer.writeBooleanValue("exploitsAvailable", this.getExploitsAvailable());
        writer.writeBooleanValue("hasChatter", this.getHasChatter());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeIntegerValue("priorityScore", this.getPriorityScore());
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeCollectionOfObjectValues("references", this.getReferences());
        writer.writeObjectValue("remediation", this.getRemediation());
        writer.writeEnumValue("severity", this.getSeverity());
    }
    /**
     * Sets the activeExploitsObserved property value. Indicates whether this vulnerability has any known exploits associated to known bad actors.
     * @param value Value to set for the activeExploitsObserved property.
     */
    public void setActiveExploitsObserved(@jakarta.annotation.Nullable final Boolean value) {
        this.backingStore.set("activeExploitsObserved", value);
    }
    /**
     * Sets the articles property value. Articles related to this vulnerability.
     * @param value Value to set for the articles property.
     */
    public void setArticles(@jakarta.annotation.Nullable final java.util.List<Article> value) {
        this.backingStore.set("articles", value);
    }
    /**
     * Sets the commonWeaknessEnumerationIds property value. Community-defined common weakness enumerations (CWE).
     * @param value Value to set for the commonWeaknessEnumerationIds property.
     */
    public void setCommonWeaknessEnumerationIds(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("commonWeaknessEnumerationIds", value);
    }
    /**
     * Sets the components property value. Components related to this vulnerability article.
     * @param value Value to set for the components property.
     */
    public void setComponents(@jakarta.annotation.Nullable final java.util.List<VulnerabilityComponent> value) {
        this.backingStore.set("components", value);
    }
    /**
     * Sets the createdDateTime property value. The date and time when this vulnerability article was first created.
     * @param value Value to set for the createdDateTime property.
     */
    public void setCreatedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("createdDateTime", value);
    }
    /**
     * Sets the cvss2Summary property value. The cvss2Summary property
     * @param value Value to set for the cvss2Summary property.
     */
    public void setCvss2Summary(@jakarta.annotation.Nullable final CvssSummary value) {
        this.backingStore.set("cvss2Summary", value);
    }
    /**
     * Sets the cvss3Summary property value. The cvss3Summary property
     * @param value Value to set for the cvss3Summary property.
     */
    public void setCvss3Summary(@jakarta.annotation.Nullable final CvssSummary value) {
        this.backingStore.set("cvss3Summary", value);
    }
    /**
     * Sets the description property value. The description property
     * @param value Value to set for the description property.
     */
    public void setDescription(@jakarta.annotation.Nullable final FormattedContent value) {
        this.backingStore.set("description", value);
    }
    /**
     * Sets the exploits property value. Known exploits for this vulnerability.
     * @param value Value to set for the exploits property.
     */
    public void setExploits(@jakarta.annotation.Nullable final java.util.List<Hyperlink> value) {
        this.backingStore.set("exploits", value);
    }
    /**
     * Sets the exploitsAvailable property value. Indicates whether this vulnerability has exploits in public sources (such as Packetstorm or Exploit-DB) online.
     * @param value Value to set for the exploitsAvailable property.
     */
    public void setExploitsAvailable(@jakarta.annotation.Nullable final Boolean value) {
        this.backingStore.set("exploitsAvailable", value);
    }
    /**
     * Sets the hasChatter property value. Indicates whether chatter about this vulnerability has been discovered online.
     * @param value Value to set for the hasChatter property.
     */
    public void setHasChatter(@jakarta.annotation.Nullable final Boolean value) {
        this.backingStore.set("hasChatter", value);
    }
    /**
     * Sets the lastModifiedDateTime property value. The date and time when this vulnerability article was most recently updated.
     * @param value Value to set for the lastModifiedDateTime property.
     */
    public void setLastModifiedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", value);
    }
    /**
     * Sets the priorityScore property value. A unique algorithm that reflects the priority of a vulnerability based on the CVSS score, exploits, chatter, and linkage to malware. This property also evaluates the recency of these components so users can understand which vulnerability should be remediated first.
     * @param value Value to set for the priorityScore property.
     */
    public void setPriorityScore(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("priorityScore", value);
    }
    /**
     * Sets the publishedDateTime property value. The date and time when this vulnerability article was published.
     * @param value Value to set for the publishedDateTime property.
     */
    public void setPublishedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", value);
    }
    /**
     * Sets the references property value. Reference links where further information can be learned about this vulnerability.
     * @param value Value to set for the references property.
     */
    public void setReferences(@jakarta.annotation.Nullable final java.util.List<Hyperlink> value) {
        this.backingStore.set("references", value);
    }
    /**
     * Sets the remediation property value. Any known remediation steps.
     * @param value Value to set for the remediation property.
     */
    public void setRemediation(@jakarta.annotation.Nullable final FormattedContent value) {
        this.backingStore.set("remediation", value);
    }
    /**
     * Sets the severity property value. The severity property
     * @param value Value to set for the severity property.
     */
    public void setSeverity(@jakarta.annotation.Nullable final VulnerabilitySeverity value) {
        this.backingStore.set("severity", value);
    }
}
