package com.microsoft.graph.beta.models.security;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class MalwareEvidence extends AlertEvidence implements Parsable {
    /**
     * Instantiates a new {@link MalwareEvidence} and sets the default values.
     */
    public MalwareEvidence() {
        super();
        this.setOdataType("#microsoft.graph.security.malwareEvidence");
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link MalwareEvidence}
     */
    @jakarta.annotation.Nonnull
    public static MalwareEvidence createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MalwareEvidence();
    }
    /**
     * Gets the category property value. The category property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getCategory() {
        return this.backingStore.get("category");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("category", (n) -> { this.setCategory(n.getStringValue()); });
        deserializerMap.put("files", (n) -> { this.setFiles(n.getCollectionOfObjectValues(FileEvidence::createFromDiscriminatorValue)); });
        deserializerMap.put("name", (n) -> { this.setName(n.getStringValue()); });
        deserializerMap.put("processes", (n) -> { this.setProcesses(n.getCollectionOfObjectValues(ProcessEvidence::createFromDiscriminatorValue)); });
        return deserializerMap;
    }
    /**
     * Gets the files property value. The files property
     * @return a {@link java.util.List<FileEvidence>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<FileEvidence> getFiles() {
        return this.backingStore.get("files");
    }
    /**
     * Gets the name property value. The name property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getName() {
        return this.backingStore.get("name");
    }
    /**
     * Gets the processes property value. The processes property
     * @return a {@link java.util.List<ProcessEvidence>}
     */
    @jakarta.annotation.Nullable
    public java.util.List<ProcessEvidence> getProcesses() {
        return this.backingStore.get("processes");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("category", this.getCategory());
        writer.writeCollectionOfObjectValues("files", this.getFiles());
        writer.writeStringValue("name", this.getName());
        writer.writeCollectionOfObjectValues("processes", this.getProcesses());
    }
    /**
     * Sets the category property value. The category property
     * @param value Value to set for the category property.
     */
    public void setCategory(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("category", value);
    }
    /**
     * Sets the files property value. The files property
     * @param value Value to set for the files property.
     */
    public void setFiles(@jakarta.annotation.Nullable final java.util.List<FileEvidence> value) {
        this.backingStore.set("files", value);
    }
    /**
     * Sets the name property value. The name property
     * @param value Value to set for the name property.
     */
    public void setName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("name", value);
    }
    /**
     * Sets the processes property value. The processes property
     * @param value Value to set for the processes property.
     */
    public void setProcesses(@jakarta.annotation.Nullable final java.util.List<ProcessEvidence> value) {
        this.backingStore.set("processes", value);
    }
}
