package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Entity that represents a Chromebook tenant settings
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class ChromeOSOnboardingSettings extends Entity implements Parsable {
    /**
     * Instantiates a new {@link ChromeOSOnboardingSettings} and sets the default values.
     */
    public ChromeOSOnboardingSettings() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link ChromeOSOnboardingSettings}
     */
    @jakarta.annotation.Nonnull
    public static ChromeOSOnboardingSettings createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ChromeOSOnboardingSettings();
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("lastDirectorySyncDateTime", (n) -> { this.setLastDirectorySyncDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastModifiedDateTime", (n) -> { this.setLastModifiedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("onboardingStatus", (n) -> { this.setOnboardingStatus(n.getEnumValue(OnboardingStatus::forValue)); });
        deserializerMap.put("ownerUserPrincipalName", (n) -> { this.setOwnerUserPrincipalName(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the lastDirectorySyncDateTime property value. The ChromebookTenant&apos;s LastDirectorySyncDateTime
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastDirectorySyncDateTime() {
        return this.backingStore.get("lastDirectorySyncDateTime");
    }
    /**
     * Gets the lastModifiedDateTime property value. The ChromebookTenant&apos;s LastModifiedDateTime
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return this.backingStore.get("lastModifiedDateTime");
    }
    /**
     * Gets the onboardingStatus property value. The onboarding status of the tenant.
     * @return a {@link OnboardingStatus}
     */
    @jakarta.annotation.Nullable
    public OnboardingStatus getOnboardingStatus() {
        return this.backingStore.get("onboardingStatus");
    }
    /**
     * Gets the ownerUserPrincipalName property value. The ChromebookTenant&apos;s OwnerUserPrincipalName
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getOwnerUserPrincipalName() {
        return this.backingStore.get("ownerUserPrincipalName");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("lastDirectorySyncDateTime", this.getLastDirectorySyncDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("onboardingStatus", this.getOnboardingStatus());
        writer.writeStringValue("ownerUserPrincipalName", this.getOwnerUserPrincipalName());
    }
    /**
     * Sets the lastDirectorySyncDateTime property value. The ChromebookTenant&apos;s LastDirectorySyncDateTime
     * @param value Value to set for the lastDirectorySyncDateTime property.
     */
    public void setLastDirectorySyncDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastDirectorySyncDateTime", value);
    }
    /**
     * Sets the lastModifiedDateTime property value. The ChromebookTenant&apos;s LastModifiedDateTime
     * @param value Value to set for the lastModifiedDateTime property.
     */
    public void setLastModifiedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", value);
    }
    /**
     * Sets the onboardingStatus property value. The onboarding status of the tenant.
     * @param value Value to set for the onboardingStatus property.
     */
    public void setOnboardingStatus(@jakarta.annotation.Nullable final OnboardingStatus value) {
        this.backingStore.set("onboardingStatus", value);
    }
    /**
     * Sets the ownerUserPrincipalName property value. The ChromebookTenant&apos;s OwnerUserPrincipalName
     * @param value Value to set for the ownerUserPrincipalName property.
     */
    public void setOwnerUserPrincipalName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("ownerUserPrincipalName", value);
    }
}
