package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class AwsEc2Instance extends AwsIdentity implements Parsable {
    /**
     * Instantiates a new {@link AwsEc2Instance} and sets the default values.
     */
    public AwsEc2Instance() {
        super();
        this.setOdataType("#microsoft.graph.awsEc2Instance");
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link AwsEc2Instance}
     */
    @jakarta.annotation.Nonnull
    public static AwsEc2Instance createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AwsEc2Instance();
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("resource", (n) -> { this.setResource(n.getObjectValue(AwsAuthorizationSystemResource::createFromDiscriminatorValue)); });
        return deserializerMap;
    }
    /**
     * Gets the resource property value. Represents the resources in an authorization system.
     * @return a {@link AwsAuthorizationSystemResource}
     */
    @jakarta.annotation.Nullable
    public AwsAuthorizationSystemResource getResource() {
        return this.backingStore.get("resource");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("resource", this.getResource());
    }
    /**
     * Sets the resource property value. Represents the resources in an authorization system.
     * @param value Value to set for the resource property.
     */
    public void setResource(@jakarta.annotation.Nullable final AwsAuthorizationSystemResource value) {
        this.backingStore.set("resource", value);
    }
}
