/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.diagnostics.logging;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class SpxTrace {
    private static final int __SPX_TRACE_LEVEL_INFO = 8;
    private static final int __SPX_TRACE_LEVEL_WARNING = 4;
    private static final int __SPX_TRACE_LEVEL_ERROR = 2;
    private static final int __SPX_TRACE_LEVEL_VERBOSE = 16;

    private SpxTrace() {
    }

    private static CallerInfo getCallerInfo() {
        String string = "";
        int n = 0;
        try {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            if (stackTraceElement != null) {
                string = stackTraceElement.getFileName();
                n = stackTraceElement.getLineNumber();
                if (string == null) {
                    string = "";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CallerInfo(string, n);
    }

    private static Object[] args(Object ... objectArray) {
        return objectArray;
    }

    public static void SPX_TRACE_INFO(String string) {
        CallerInfo callerInfo = SpxTrace.getCallerInfo();
        SpxTrace.SPX_TRACE_INFO(string, SpxTrace.args(new Object[0]), callerInfo.lineNumber, callerInfo.fileName);
    }

    public static void SPX_TRACE_WARNING(String string) {
        CallerInfo callerInfo = SpxTrace.getCallerInfo();
        SpxTrace.SPX_TRACE_WARNING(string, SpxTrace.args(new Object[0]), callerInfo.lineNumber, callerInfo.fileName);
    }

    public static void SPX_TRACE_ERROR(String string) {
        CallerInfo callerInfo = SpxTrace.getCallerInfo();
        SpxTrace.SPX_TRACE_ERROR(string, SpxTrace.args(new Object[0]), callerInfo.lineNumber, callerInfo.fileName);
    }

    public static void SPX_TRACE_VERBOSE(String string) {
        CallerInfo callerInfo = SpxTrace.getCallerInfo();
        SpxTrace.SPX_TRACE_VERBOSE(string, SpxTrace.args(new Object[0]), callerInfo.lineNumber, callerInfo.fileName);
    }

    public static void SPX_TRACE_INFO(String string, Object[] objectArray, int n, String string2) {
        SpxTrace.SPX_TRACE_HELPER(8, "SPX_TRACE_INFO", string, objectArray, n, string2);
    }

    public static void SPX_TRACE_WARNING(String string, Object[] objectArray, int n, String string2) {
        SpxTrace.SPX_TRACE_HELPER(4, "SPX_TRACE_WARNING", string, objectArray, n, string2);
    }

    public static void SPX_TRACE_ERROR(String string, Object[] objectArray, int n, String string2) {
        SpxTrace.SPX_TRACE_HELPER(2, "SPX_TRACE_ERROR", string, objectArray, n, string2);
    }

    public static void SPX_TRACE_VERBOSE(String string, Object[] objectArray, int n, String string2) {
        SpxTrace.SPX_TRACE_HELPER(16, "SPX_TRACE_VERBOSE", string, objectArray, n, string2);
    }

    private static void SPX_TRACE_HELPER(int n, String string, String string2, Object[] objectArray, int n2, String string3) {
        Contracts.throwIfNull(string, "title");
        Contracts.throwIfNull(string2, "format");
        Contracts.throwIfNull(objectArray, "args");
        Contracts.throwIfNull(string3, "file");
        String string4 = String.format(string2, objectArray);
        Contracts.throwIfFail(SpxTrace.logTraceString(n, string, string3, n2, string4));
    }

    private static final native long logTraceString(int var0, String var1, String var2, int var3, String var4);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    private static class CallerInfo {
        public String fileName;
        public int lineNumber;

        public CallerInfo(String string, int n) {
            this.fileName = string;
            this.lineNumber = n;
        }
    }
}

