/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class PropertyCollection
implements AutoCloseable {
    private SafeHandle propertyHandle = null;

    public PropertyCollection(IntRef intRef) {
        if (intRef != null) {
            this.propertyHandle = new SafeHandle(intRef.getValue(), SafeHandleType.PropertyCollection);
        }
    }

    public String getProperty(String string) {
        return this.getPropertyString(this.propertyHandle, -1, string, "");
    }

    public String getProperty(String string, String string2) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNullOrWhitespace(string, "name");
        return this.getPropertyString(this.propertyHandle, -1, string, string2);
    }

    public String getProperty(PropertyId propertyId) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        return this.getPropertyString(this.propertyHandle, propertyId.getValue(), null, "");
    }

    public void setProperty(String string, String string2) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNullOrWhitespace(string, "name");
        Contracts.throwIfNull(string2, "value");
        Contracts.throwIfFail(this.setPropertyString(this.propertyHandle, -1, string, string2));
    }

    public void setProperty(PropertyId propertyId, String string) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNull(string, "value");
        Contracts.throwIfFail(this.setPropertyString(this.propertyHandle, propertyId.getValue(), null, string));
    }

    @Override
    public void close() {
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
    }

    private final native long setPropertyString(SafeHandle var1, int var2, String var3, String var4);

    private final native String getPropertyString(SafeHandle var1, int var2, String var3, String var4);
}

