/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.diagnostics.logging;

import com.microsoft.cognitiveservices.speech.Diagnostics;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Level;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Logger;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class FileLogger {
    private FileLogger() {
    }

    public static void start(String string) {
        Contracts.throwIfNullOrWhitespace(string, "filePath");
        FileLogger.start(string, false);
    }

    public static void start(String string, boolean bl) {
        Contracts.throwIfNullOrWhitespace(string, "filePath");
        Diagnostics.startFileLogging(string, bl);
    }

    public static void stop() {
        Diagnostics.stopFileLogging();
    }

    public static void setFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Logger.fileLoggerSetFilters(stringArray);
    }

    public static void setFilters() {
        Logger.fileLoggerSetFilters(new String[0]);
    }

    public static void setLevel(Level level) {
        Contracts.throwIfNull((Object)level, "level");
        Logger.setLevel(Logger.Type.File, level);
    }
}

