/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SessionEventArgs {
    protected SafeHandle eventHandle = null;
    private String sessionId;
    private final int maxUUID = 36;
    private final int maxSessionID = 37;

    public SessionEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        this.eventHandle = new SafeHandle(l, SafeHandleType.Event);
        this.storeEventData(false);
    }

    public SessionEventArgs(long l, boolean bl) {
        Contracts.throwIfNull(l, "eventArgs");
        this.eventHandle = new SafeHandle(l, SafeHandleType.Event);
        this.storeEventData(bl);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "SessionId: " + this.sessionId + ".";
    }

    protected void close() {
        if (this.eventHandle != null) {
            this.eventHandle.close();
            this.eventHandle = null;
        }
    }

    private void storeEventData(boolean bl) {
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getSessionId(this.eventHandle, stringRef, 37));
        this.sessionId = stringRef.getValue();
        Contracts.throwIfNull(this.sessionId, "SessionId");
        if (bl) {
            this.close();
        }
    }

    private final native long getSessionId(SafeHandle var1, StringRef var2, int var3);
}

