/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

class NativeLibraryLoader {
    private static final String tempDirPrefix = "speech-sdk-native-";
    private static final String lockFileExtension = ".lock";
    private static NativeLibrary[] nativeList = new NativeLibrary[0];
    private static NativeLibrary[] externalNativeList = new NativeLibrary[0];
    private static String operatingSystem;
    private static Boolean windowsOperatingSystem;
    private static Boolean extractionDone;
    private static Boolean loadAll;
    private static File tempDir;

    NativeLibraryLoader() {
    }

    public static void loadNativeBinding() {
        try {
            NativeLibraryLoader.extractNativeLibraries();
            for (int i = 0; i < nativeList.length; ++i) {
                if (!loadAll.booleanValue() && i != nativeList.length - 1) continue;
                String string = nativeList[i].getName();
                String string2 = new File(tempDir.getCanonicalPath(), string).getCanonicalPath();
                if (!string2.startsWith(tempDir.getCanonicalPath())) {
                    String string3 = String.format("illegal path: %s", string2);
                    throw new SecurityException(string3);
                }
                try {
                    System.load(string2);
                    continue;
                }
                catch (Throwable throwable) {
                    String string4 = String.format("failed to load %s: %s: %s", string2, throwable.getClass().getCanonicalName(), throwable.getMessage());
                    if (!nativeList[i].getRequired()) continue;
                    throw new UnsatisfiedLinkError(string4);
                }
            }
        }
        catch (Throwable throwable) {
            String string = String.format("Could not extract/load all Speech SDK libraries because of the following error: %s: %s", throwable.getClass().getCanonicalName(), throwable.getMessage());
            System.err.println(string);
            throw new UnsatisfiedLinkError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void extractNativeLibraries() throws Exception {
        block11: {
            try {
                if (extractionDone.booleanValue()) break block11;
                for (NativeLibrary nativeLibrary : nativeList = NativeLibraryLoader.getResourceLines()) {
                    NativeLibraryLoader.extractResourceFromPath(nativeLibrary, NativeLibraryLoader.getResourcesPath());
                }
                externalNativeList = NativeLibraryLoader.getExternalResourceLines();
                if (!windowsOperatingSystem.booleanValue()) break block11;
                Object var0_1 = null;
                try {
                    void var0_5;
                    URL uRL = ClassLoader.getSystemClassLoader().getResource(".");
                    if (uRL != null) {
                        String string = new File(uRL.getPath()).getAbsolutePath();
                    } else {
                        String string = new File(NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
                        if (string.endsWith("jar")) {
                            String string2 = new File(string).getParent();
                        }
                    }
                    String string = URLDecoder.decode((String)var0_5, "UTF-8");
                    if (string != null) {
                        for (NativeLibrary nativeLibrary : externalNativeList) {
                            NativeLibraryLoader.copyLibraryFromPath(nativeLibrary, string);
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println(String.format("Could not copy external Speech SDK libraries because of the following error: %s", exception.getMessage()));
                }
            }
            finally {
                extractionDone = true;
            }
        }
    }

    private static NativeLibrary[] getResourceLines() throws IOException {
        if (operatingSystem.contains("linux")) {
            return new NativeLibrary[]{new NativeLibrary("libMicrosoft.CognitiveServices.Speech.core.so", true), new NativeLibrary("libpal_azure_c_shared.so", false), new NativeLibrary("libpal_azure_c_shared_openssl3.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.kws.ort.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.kws.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.codec.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.audio.sys.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.lu.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.onnxruntime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.runtime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.runtime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.telemetry.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.mas.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.vad.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.java.bindings.so", true)};
        }
        if (windowsOperatingSystem.booleanValue()) {
            return new NativeLibrary[]{new NativeLibrary("Microsoft.CognitiveServices.Speech.core.dll", true), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.kws.ort.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.kws.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.codec.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.audio.sys.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.lu.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.silk_codec.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.onnxruntime.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.sr.runtime.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.sr.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.tts.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.telemetry.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.mas.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.vad.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.java.bindings.dll", true)};
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibrary[]{new NativeLibrary("libMicrosoft.CognitiveServices.Speech.core.dylib", true), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.audio.sys.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.onnxruntime.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.runtime.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.telemetry.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.java.bindings.dylib", true)};
        }
        throw new UnsatisfiedLinkError(String.format("The Speech SDK doesn't currently have native support for operating system: %s", operatingSystem));
    }

    private static NativeLibrary[] getExternalResourceLines() {
        if (windowsOperatingSystem.booleanValue()) {
            return new NativeLibrary[]{new NativeLibrary("carbon-tts-mock.dll", false)};
        }
        if (operatingSystem.contains("linux")) {
            return new NativeLibrary[0];
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibrary[0];
        }
        return new NativeLibrary[0];
    }

    private static String getResourcesPath() {
        String string = "/ASSETS/%s%s/";
        String string2 = System.getProperty("sun.arch.data.model");
        string2 = string2 != null && string2.equals("64") ? "64" : "32";
        if (operatingSystem.contains("linux")) {
            String string3 = System.getProperty("os.arch");
            if (string3.contains("aarch64") || string3.contains("arm")) {
                return String.format(string, "linux-arm", string2);
            }
            if (string3.contains("amd64") || string3.contains("x86_64")) {
                return String.format(string, "linux-x", string2);
            }
        } else {
            if (windowsOperatingSystem.booleanValue()) {
                loadAll = true;
                return String.format(string, "windows", string2);
            }
            if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
                String string4 = System.getProperty("os.arch");
                if (string4.contains("aarch64") || string4.contains("arm")) {
                    return String.format(string, "osx-arm", string2);
                }
                if (string4.contains("amd64") || string4.contains("x86_64")) {
                    return String.format(string, "osx-x", string2);
                }
            }
        }
        throw new UnsatisfiedLinkError(String.format("The Speech SDK doesn't currently have native support for operating system: %s data model size %s", operatingSystem, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractResourceFromPath(NativeLibrary nativeLibrary, String string) throws IOException {
        String string2 = nativeLibrary.getName();
        File file = new File(tempDir.getCanonicalPath(), string2);
        if (!file.getCanonicalPath().startsWith(tempDir.getCanonicalPath())) {
            throw new SecurityException("illegal name " + file.getCanonicalPath());
        }
        file.createNewFile();
        file.deleteOnExit();
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("Temporary file %s could not be created. Make sure you can write to this location.", file.getCanonicalPath()));
        }
        String string3 = string + string2;
        InputStream inputStream = SpeechConfig.class.getResourceAsStream(string3);
        if (inputStream == null) {
            if (nativeLibrary.getRequired()) {
                throw new FileNotFoundException(String.format("Could not find resource %s in jar.", string3));
            }
            return;
        }
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[0x100000];
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            NativeLibraryLoader.safeClose(fileOutputStream);
            NativeLibraryLoader.safeClose(inputStream);
            throw throwable;
        }
        NativeLibraryLoader.safeClose(fileOutputStream);
        NativeLibraryLoader.safeClose(inputStream);
    }

    private static void copyLibraryFromPath(NativeLibrary nativeLibrary, String string) throws Exception {
        String string2 = nativeLibrary.getName();
        File file = new File(string, string2);
        if (!file.exists()) {
            return;
        }
        File file2 = new File(tempDir.getCanonicalPath(), string2);
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            return;
        }
        file2.deleteOnExit();
        Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        extractionDone = false;
        loadAll = false;
        operatingSystem = ("" + System.getProperty("os.name")).toLowerCase();
        windowsOperatingSystem = operatingSystem.contains("windows");
        try {
            if (windowsOperatingSystem.booleanValue()) {
                File file = Files.createTempFile(tempDirPrefix, lockFileExtension, new FileAttribute[0]).toFile();
                file.createNewFile();
                file.deleteOnExit();
                String string = file.getAbsolutePath();
                string = string.substring(0, string.length() - lockFileExtension.length());
                tempDir = Files.createDirectory(Paths.get(string, new String[0]), new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
                Thread thread = new Thread(new DeleteUnlockedTempFolders());
                thread.start();
            } else {
                tempDir = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static class DeleteUnlockedTempFolders
    implements Runnable {
        private DeleteUnlockedTempFolders() {
        }

        @Override
        public void run() {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().startsWith(NativeLibraryLoader.tempDirPrefix) && !file.getName().endsWith(NativeLibraryLoader.lockFileExtension);
                }
            };
            File file = new File(System.getProperty("java.io.tmpdir"));
            File[] fileArray = file.listFiles(fileFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = new File(fileArray[i].getAbsolutePath() + NativeLibraryLoader.lockFileExtension);
                if (file2.exists()) continue;
                try {
                    Files.walkFileTree(Paths.get(fileArray[i].getAbsolutePath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            Files.delete(path);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fileArray[i].delete();
            }
        }
    }

    private static class NativeLibrary {
        private String name;
        private boolean required;

        public NativeLibrary(String string, boolean bl) {
            this.name = string;
            this.required = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean getRequired() {
            return this.required;
        }

        private void setName() {
            this.name = this.name;
        }

        private void setRequired() {
            this.required = this.required;
        }
    }
}

