/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.speaker.SpeakerIdentificationModel;
import com.microsoft.cognitiveservices.speech.speaker.SpeakerRecognitionResult;
import com.microsoft.cognitiveservices.speech.speaker.SpeakerVerificationModel;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class SpeakerRecognizer
implements AutoCloseable {
    private SafeHandle recoHandle = null;
    private AudioConfig audioInputKeepAlive = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public SpeakerRecognizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        IntRef intRef = new IntRef(0L);
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createFromConfig(intRef, speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createFromConfig(intRef, speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.recoHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SpeakerRecognizer);
        this.audioInputKeepAlive = audioConfig;
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<SpeakerRecognitionResult> recognizeOnceAsync(final SpeakerVerificationModel speakerVerificationModel) {
        return AsyncThreadService.submit(new Callable<SpeakerRecognitionResult>(){

            @Override
            public SpeakerRecognitionResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(SpeakerRecognizer.this.verifyOnce(SpeakerRecognizer.this.recoHandle, speakerVerificationModel.getImpl(), intRef));
                return new SpeakerRecognitionResult(intRef.getValue());
            }
        });
    }

    public Future<SpeakerRecognitionResult> recognizeOnceAsync(final SpeakerIdentificationModel speakerIdentificationModel) {
        return AsyncThreadService.submit(new Callable<SpeakerRecognitionResult>(){

            @Override
            public SpeakerRecognitionResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(SpeakerRecognizer.this.identifyOnce(SpeakerRecognizer.this.recoHandle, speakerIdentificationModel.getImpl(), intRef));
                return new SpeakerRecognitionResult(intRef.getValue());
            }
        });
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.recoHandle != null) {
            this.recoHandle.close();
            this.recoHandle = null;
        }
        this.audioInputKeepAlive = null;
        AsyncThreadService.shutdown();
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        SpeakerRecognizer speakerRecognizer = this;
        AsyncThreadService.initialize();
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(speakerRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private final native long createFromConfig(IntRef var1, SafeHandle var2, SafeHandle var3);

    private final native long verifyOnce(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long identifyOnce(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long getPropertyBagFromRecognizerHandle(SafeHandle var1, IntRef var2);
}

