/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayType;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneCoordinates;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public class MicrophoneArrayGeometry {
    private MicrophoneArrayType microphoneArrayType;
    private int beamformingStartAngle;
    private int beamformingEndAngle;
    private MicrophoneCoordinates[] microphoneCoordinates;

    public MicrophoneArrayGeometry(MicrophoneArrayType microphoneArrayType, MicrophoneCoordinates[] microphoneCoordinatesArray) {
        Contracts.throwIfNull(microphoneCoordinatesArray, "microphoneCoordinates");
        this.microphoneArrayType = microphoneArrayType;
        this.beamformingStartAngle = 0;
        this.beamformingEndAngle = microphoneArrayType == MicrophoneArrayType.Linear ? 180 : 360;
        this.microphoneCoordinates = new MicrophoneCoordinates[microphoneCoordinatesArray.length];
        for (int i = 0; i < microphoneCoordinatesArray.length; ++i) {
            this.microphoneCoordinates[i] = new MicrophoneCoordinates(microphoneCoordinatesArray[i]);
        }
    }

    public MicrophoneArrayGeometry(MicrophoneArrayType microphoneArrayType, int n, int n2, MicrophoneCoordinates[] microphoneCoordinatesArray) {
        Contracts.throwIfNull(microphoneCoordinatesArray, "microphoneCoordinates");
        if (n < 0) {
            throw new IllegalArgumentException("beamformingStartAngle cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("beamformingEndAngle cannot be negative");
        }
        this.microphoneArrayType = microphoneArrayType;
        this.beamformingStartAngle = n;
        this.beamformingEndAngle = n2;
        this.microphoneCoordinates = new MicrophoneCoordinates[microphoneCoordinatesArray.length];
        for (int i = 0; i < microphoneCoordinatesArray.length; ++i) {
            this.microphoneCoordinates[i] = new MicrophoneCoordinates(microphoneCoordinatesArray[i]);
        }
    }

    public MicrophoneArrayType getMicrophoneArrayType() {
        return this.microphoneArrayType;
    }

    public int getBeamformingStartAngle() {
        return this.beamformingStartAngle;
    }

    public int getBeamformingEndAngle() {
        return this.beamformingEndAngle;
    }

    public MicrophoneCoordinates[] getMicrophoneCoordinates() {
        MicrophoneCoordinates[] microphoneCoordinatesArray = new MicrophoneCoordinates[this.microphoneCoordinates.length];
        for (int i = 0; i < microphoneCoordinatesArray.length; ++i) {
            microphoneCoordinatesArray[i] = new MicrophoneCoordinates(this.microphoneCoordinates[i]);
        }
        return microphoneCoordinatesArray;
    }
}

