/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public final class VoiceProfileResult
implements AutoCloseable {
    private SafeHandle resultHandle = null;
    private PropertyCollection properties = null;
    private String resultId = "";
    private ResultReason reason;

    VoiceProfileResult(long l) {
        Contracts.throwIfNull(l, "result");
        this.resultHandle = new SafeHandle(l, SafeHandleType.VoiceProfileResult);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef));
        this.reason = ResultReason.values()[(int)intRef.getValue()];
        IntRef intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, intRef2));
        this.properties = new PropertyCollection(intRef2);
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public String toString() {
        return "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + " Json:" + this.properties.getProperty(PropertyId.SpeechServiceResponse_JsonResult);
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.resultHandle, "result");
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);
}

