/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionResult;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public final class KeywordRecognizer
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<KeywordRecognitionEventArgs> recognized = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechRecognitionCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    static Set<KeywordRecognizer> keywordRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle recoHandle = new SafeHandle(0L, SafeHandleType.KeywordRecognizer);
    private AudioConfig audioInputKeepAlive = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public KeywordRecognizer(AudioConfig audioConfig) {
        SafeHandle safeHandle = audioConfig == null ? null : audioConfig.getImpl();
        Contracts.throwIfFail(this.createKeywordRecognizerFromConfig(this.recoHandle, safeHandle));
        this.audioInputKeepAlive = audioConfig;
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<KeywordRecognitionResult> recognizeOnceAsync(final KeywordRecognitionModel keywordRecognitionModel) {
        return AsyncThreadService.submit(new Callable<KeywordRecognitionResult>(){

            @Override
            public KeywordRecognitionResult call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(KeywordRecognizer.this.recognizeOnce(KeywordRecognizer.this.recoHandle, keywordRecognitionModel.getImpl(), intRef));
                return new KeywordRecognitionResult(intRef.getValue());
            }
        });
    }

    public Future<Void> stopRecognitionAsync() {
        final KeywordRecognizer keywordRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        keywordRecognizer.stopRecognition(KeywordRecognizer.this.recoHandle);
                    }
                };
                return null;
            }
        });
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    private void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            this.audioInputKeepAlive = null;
            keywordRecognizerObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    public SafeHandle getImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final KeywordRecognizer keywordRecognizer = this;
        AsyncThreadService.initialize();
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                keywordRecognizerObjects.add(keywordRecognizer);
                Contracts.throwIfFail(KeywordRecognizer.this.recognizedSetCallback(keywordRecognizer.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                keywordRecognizerObjects.add(keywordRecognizer);
                Contracts.throwIfFail(KeywordRecognizer.this.canceledSetCallback(keywordRecognizer.recoHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(keywordRecognizer.recoHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            KeywordRecognitionEventArgs keywordRecognitionEventArgs = new KeywordRecognitionEventArgs(l, true);
            EventHandlerImpl<KeywordRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, keywordRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionCanceledEventArgs speechRecognitionCanceledEventArgs = new SpeechRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<SpeechRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, speechRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createKeywordRecognizerFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long recognizeOnce(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long stopRecognition(SafeHandle var1);

    private final native long recognizedSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long getPropertyBagFromRecognizerHandle(SafeHandle var1, IntRef var2);
}

