//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//

#include "com_microsoft_cognitiveservices_speech_util_JsonValueJNI.h"
#include "jni_utils.h"
#include "speechapi_c_json.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    createJsonParserHandle
 * Signature: (Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_createJsonParserHandle
        (JNIEnv *env, jclass, jstring jjson, jobject parserHandle) {
    SPXHANDLE handle = SPXHANDLE_INVALID;
    const char *json = GetStringUTFChars(env, jjson);
    jsize size = env->GetStringUTFLength(jjson);
    int item = ai_core_json_parser_create(&handle, json, size);
    if (item >= 0) {
        SetObjectHandle(env, parserHandle, (jlong) handle);
    }
    ReleaseStringUTFChars(env, jjson, json);
    return (jint) item;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    count
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;I)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_count
        (JNIEnv *env, jclass, jobject parserHandle, jint item) {
    jlong parser = GetObjectHandle(env, parserHandle);
    return (jint) ai_core_json_item_count((SPXHANDLE) parser, item);
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    asString
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILjava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_asString
        (JNIEnv *env, jclass, jobject parserHandle, jint item, jstring defaultValue) {
    jlong parser = GetObjectHandle(env, parserHandle);
    const char *value = GetStringUTFChars(env, defaultValue);
    const char *res = ai_core_json_value_as_string_copy((SPXHANDLE) parser, item, value);
    jstring result = env->NewStringUTF(res);
    ai_core_string_free(res);
    ReleaseStringUTFChars(env, defaultValue, value);
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    asInt
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;IJ)I
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_asInt
        (JNIEnv *env, jclass, jobject parserHandle, jint item, jlong defaultValue) {
    jlong parser = GetObjectHandle(env, parserHandle);
    return (jlong) ai_core_json_value_as_int((SPXHANDLE) parser, item, defaultValue);
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    asDouble
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ID)D
 */
JNIEXPORT jdouble JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_asDouble
        (JNIEnv *env, jclass, jobject parserHandle, jint item, jdouble defaultValue) {
    jlong parser = GetObjectHandle(env, parserHandle);
    return (jdouble) ai_core_json_value_as_double((SPXHANDLE) parser, item, defaultValue);
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    asBoolean
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;IZ)Z
 */
JNIEXPORT jboolean JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_asBoolean
        (JNIEnv *env, jclass, jobject parserHandle, jint item, jboolean defaultValue) {
    jlong parser = GetObjectHandle(env, parserHandle);
    return (jboolean) ai_core_json_value_as_bool((SPXHANDLE) parser, item, defaultValue);
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    asJson
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_asJson
        (JNIEnv *env, jclass, jobject parserHandle, jint item) {
    jlong parser = GetObjectHandle(env, parserHandle);
    const char *res = ai_core_json_value_as_json_copy((SPXHANDLE) parser, item);
    jstring result = env->NewStringUTF(res);
    ai_core_string_free(res);

    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    kind
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;I)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_kind
        (JNIEnv *env, jclass, jobject parserHandle, jint item) {
    jlong parser = GetObjectHandle(env, parserHandle);
    return (jint) ai_core_json_value_kind((SPXHANDLE) parser, item);
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    get
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_get
        (JNIEnv *env, jclass, jobject parserHandle, jint item, jint index, jstring key) {
    const char *keyptr = GetStringUTFChars(env, key);
    jlong parser = GetObjectHandle(env, parserHandle);
    int newItem = (jlong) ai_core_json_item_at((SPXHANDLE) parser, item, index, keyptr);
    ReleaseStringUTFChars(env, key, keyptr);
    return (jint) newItem;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_JsonValueJNI
 * Method:    getName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;II)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_util_JsonValueJNI_getName
  (JNIEnv * env, jclass, jobject parserHandle, jint item, jint index) {
    jlong parser = GetObjectHandle(env, parserHandle);
    int newItem = ai_core_json_item_at((SPXHANDLE) parser, item, index, nullptr);
    int nameItem = ai_core_json_item_name((SPXHANDLE) parser, newItem);
    const char *res = ai_core_json_value_as_string_copy((SPXHANDLE) parser, nameItem, "");
    jstring result = env->NewStringUTF(res);
    ai_core_string_free(res);
    return result;
  }
