//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_transcription_ConversationTranscriptionResult.h"
#include "jni_utils.h"
#include "speechapi_c_conversation_transcription_result.h"

const size_t maxCharCount = 2048;

/*
 * Class:     com_microsoft_cognitiveservices_speech_transcription_ConversationTranscriptionResult
 * Method:    getSpeakerId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_transcription_ConversationTranscriptionResult_getSpeakerId
  (JNIEnv *env, jobject , jobject resultHandle, jobject speakerIdStr)
{
    jlong result = GetObjectHandle(env, resultHandle);
    char sz[maxCharCount + 1] = {};
    SPXHR hr = conversation_transcription_result_get_speaker_id((SPXRESULTHANDLE)result, sz, maxCharCount);
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, speakerIdStr, sz);
    }
    return (jlong)hr;
}
