//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient.h"
#include "jni_utils.h"
#include "speechapi_c_speaker_recognition.h"
#include "speechapi_c_property_bag.h"
#include "speechapi_cxx_utils.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    createFromConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_createFromConfig
  (JNIEnv *env, jobject, jobject clientHandle, jobject speechConfigHandle)
{
    SPXVOICEPROFILECLIENTHANDLE voiceProfileClientHandle = SPXHANDLE_INVALID;
    jlong speechConfig = GetObjectHandle(env, speechConfigHandle);
    SPXHR hr = create_voice_profile_client_from_config(&voiceProfileClientHandle, (SPXSPEECHCONFIGHANDLE)speechConfig);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, clientHandle, (jlong)voiceProfileClientHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    createVoiceProfile
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILjava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_createVoiceProfile
  (JNIEnv *env, jobject, jobject clientHandle, jint type, jstring locale, jobject resultHandle)
{
    SPXVOICEPROFILEHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    const char* localeStr = GetStringUTFChars(env, locale);
    SPXHR hr = create_voice_profile((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, (int)type, localeStr, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    ReleaseStringUTFChars(env, locale, localeStr);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    getProfilesJson
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;I)Ljava/lang/String;
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_getProfilesJson
  (JNIEnv *env, jobject, jobject clientHandle, jint type, jobject jsonStringRef, jobject sizeRef)
{
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);

    size_t numChars = 0;
    char* str = nullptr;
    auto freeStrOnExit = Microsoft::CognitiveServices::Speech::Utils::MakeScopeGuard([&str]()
    {
        property_bag_free_string(str);
    });
    
    SPXHR hr = get_profiles_json((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, (int)type, &str, &numChars);
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, jsonStringRef, str);
    }

    if (SPX_SUCCEEDED(hr))
    {
        hr = SetObjectHandle(env, sizeRef, (jlong)numChars);
    }

    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    enrollVoiceProfile
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_enrollVoiceProfile
  (JNIEnv *env, jobject, jobject clientHandle, jobject profileHandle, jobject audioConfigHandle, jobject resultHandle)
{
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    jlong voiceProfileHandle = GetObjectHandle(env, profileHandle);
    jlong audioInput = GetObjectHandle(env, audioConfigHandle);
    SPXHR hr = enroll_voice_profile((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, (SPXVOICEPROFILEHANDLE)voiceProfileHandle, (SPXAUDIOCONFIGHANDLE)audioInput, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    deleteVoiceProfile
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_deleteVoiceProfile
  (JNIEnv *env, jobject, jobject clientHandle, jobject profileHandle, jobject resultHandle)
{
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    jlong voiceProfileHandle = GetObjectHandle(env, profileHandle);
    SPXHR hr = delete_voice_profile((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, (SPXVOICEPROFILEHANDLE)voiceProfileHandle, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    resetVoiceProfile
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_resetVoiceProfile
  (JNIEnv *env, jobject, jobject clientHandle, jobject profileHandle, jobject resultHandle)
{
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    jlong voiceProfileHandle = GetObjectHandle(env, profileHandle);
    SPXHR hr = reset_voice_profile((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, (SPXVOICEPROFILEHANDLE)voiceProfileHandle, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    retrieveEnrollmentResult
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;ILcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_retrieveEnrollmentResult
  (JNIEnv*env, jobject, jobject clientHandle, jstring id, jint type, jobject resultHandle)
{
    SPXVOICEPROFILEHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    const char* idStr = GetStringUTFChars(env, id);
    SPXHR hr = retrieve_enrollment_result((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, idStr, (int)type, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    getActivationPhrases
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILjava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_getActivationPhrases
  (JNIEnv *env, jobject, jobject clientHandle, jint type, jstring locale, jobject resultHandle)
{
    SPXVOICEPROFILEHANDLE result = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    const char* localeStr = GetStringUTFChars(env, locale);
    SPXHR hr = get_activation_phrases((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, localeStr, (int)type, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    ReleaseStringUTFChars(env, locale, localeStr);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient
 * Method:    getPropertyBagFromHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_VoiceProfileClient_getPropertyBagFromHandle
  (JNIEnv *env, jobject, jobject clientHandle, jobject propertyHandle)
{
    SPXPROPERTYBAGHANDLE progbag = SPXHANDLE_INVALID;
    jlong voiceProfileClientHandle = GetObjectHandle(env, clientHandle);
    SPXHR hr = voice_profile_client_get_property_bag((SPXVOICEPROFILECLIENTHANDLE)voiceProfileClientHandle, &progbag);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propertyHandle, (jlong)progbag);
    }
    return (jlong)hr;
}
