//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs.h"
#include "jni_utils.h"
#include "speechapi_c_synthesizer.h"
#include "speechapi_c_property_bag.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs
 * Method:    getResultId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs_getResultId
  (JNIEnv *env, jobject , jobject eventHandle, jobject resultIdRef)
{
    const size_t maxCharCount = 256;
    char sz[maxCharCount + 1] = {};
    jlong handle = GetObjectHandle(env, eventHandle);
    SPXHR hr = synthesizer_event_get_result_id((SPXRESULTHANDLE)handle, sz, maxCharCount);
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, resultIdRef, sz);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs
 * Method:    getVisemeEventValues
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs_getVisemeEventValues
  (JNIEnv *env, jobject , jobject eventHandle, jobject audioOffsetRef, jobject visemeIdRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    uint64_t audioOffset = 0;
    uint32_t visemeId = 0;
    SPXHR hr = synthesizer_viseme_event_get_values((SPXEVENTHANDLE)event, &audioOffset, &visemeId);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioOffsetRef, (jlong)audioOffset);
        SetObjectHandle(env, visemeIdRef, (jlong)visemeId);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs
 * Method:    getAnimationFromHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisVisemeEventArgs_getAnimationFromHandle
  (JNIEnv *env, jobject, jobject eventHandle, jobject animationStrRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    const char* str = synthesizer_viseme_event_get_animation((SPXEVENTHANDLE)event);
    SPXHR hr = SPXERR_RUNTIME_ERROR;
    if (str != nullptr)
    {
        hr = SetStringObjectHandle(env, animationStrRef, str);
        property_bag_free_string(str);
    }
    return hr;
}