//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_ConnectionMessage.h"
#include "jni_utils.h"
#include "speechapi_c_connection.h"
#include <vector>

/*
 * Class:     com_microsoft_cognitiveservices_speech_ConnectionMessage
 * Method:    getMessageData
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)[J
 */
JNIEXPORT jbyteArray JNICALL Java_com_microsoft_cognitiveservices_speech_ConnectionMessage_getMessageData
  (JNIEnv *env, jobject , jobject messageHandle, jobject resultHr)
{
    uint32_t messageSize = 0;
    std::vector<uint8_t> messageData;
    jbyteArray jdataBuffer = 0;
    jlong handle = GetObjectHandle(env, messageHandle);
    SPXHR hr = SPX_NOERROR;

    messageSize = connection_message_get_data_size((SPXCONNECTIONMESSAGEHANDLE)handle);

    if (messageSize > 0)
    {
        messageData.resize(messageSize);

        hr = connection_message_get_data((SPXCONNECTIONMESSAGEHANDLE)handle, messageData.data(), messageSize);

        if (SPX_SUCCEEDED(hr))
        {
            jdataBuffer = env->NewByteArray((jsize)messageSize);

            if (!jdataBuffer) hr = SPXERR_ABORT;

            if (SPX_SUCCEEDED(hr))
            {
                env->SetByteArrayRegion(jdataBuffer, 0, (jsize)messageSize, (jbyte*)messageData.data());
            }
        }
    }

    SetObjectHandle(env, resultHr, (jlong)hr);

    return jdataBuffer;
}


/*
 * Class:     com_microsoft_cognitiveservices_speech_ConnectionMessage
 * Method:    getPropertyBag
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_ConnectionMessage_getPropertyBag
  (JNIEnv *env, jobject , jobject messageHandle, jobject propertyHandle)
{
    SPXPROPERTYBAGHANDLE propBagHandle = SPXHANDLE_INVALID;
    jlong handle = GetObjectHandle(env, messageHandle);
    SPXHR hr = connection_message_get_property_bag((SPXRESULTHANDLE) handle, &propBagHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propertyHandle, (jlong)propBagHandle);
    }
    return (jlong)hr;
}
