//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech;

/**
 * Defines the possible speech synthesis output audio format.
 * Updated in version 1.19.0
 */
public enum SpeechSynthesisOutputFormat
{
    /**
     * raw-8khz-8bit-mono-mulaw
     */
    Raw8Khz8BitMonoMULaw (1),

    /**
     * riff-16khz-16kbps-mono-siren
     * Unsupported by the service. Do not use this value.
     */
    Riff16Khz16KbpsMonoSiren (2),

    /**
     * audio-16khz-16kbps-mono-siren
     * Unsupported by the service. Do not use this value.
     */
    Audio16Khz16KbpsMonoSiren (3),

    /**
     * audio-16khz-32kbitrate-mono-mp3
     */
    Audio16Khz32KBitRateMonoMp3 (4),

    /**
     * audio-16khz-128kbitrate-mono-mp3
     */
    Audio16Khz128KBitRateMonoMp3 (5),

    /**
     * audio-16khz-64kbitrate-mono-mp3
     */
    Audio16Khz64KBitRateMonoMp3 (6),

    /**
     * audio-24khz-48kbitrate-mono-mp3
     */
    Audio24Khz48KBitRateMonoMp3 (7),

    /**
     * audio-24khz-96kbitrate-mono-mp3
     */
    Audio24Khz96KBitRateMonoMp3 (8),

    /**
     * audio-24khz-160kbitrate-mono-mp3
     */
    Audio24Khz160KBitRateMonoMp3 (9),

    /**
     * raw-16khz-16bit-mono-truesilk
     */
    Raw16Khz16BitMonoTrueSilk (10),

    /**
     * riff-16khz-16bit-mono-pcm
     */
    Riff16Khz16BitMonoPcm (11),

    /**
     * riff-8khz-16bit-mono-pcm
     */
    Riff8Khz16BitMonoPcm (12),

    /**
     * riff-24khz-16bit-mono-pcm
     */
    Riff24Khz16BitMonoPcm (13),

    /**
     * riff-8khz-8bit-mono-mulaw
     */
    Riff8Khz8BitMonoMULaw (14),

    /**
     *  raw-16khz-16bit-mono-pcm
     */
    Raw16Khz16BitMonoPcm (15),

    /**
     * raw-24khz-16bit-mono-pcm
     */
    Raw24Khz16BitMonoPcm (16),

    /**
     * raw-8khz-16bit-mono-pcm
     */
    Raw8Khz16BitMonoPcm (17),

    /**
     * ogg-16khz-16bit-mono-opus
     */
    Ogg16Khz16BitMonoOpus (18),

    /**
     * ogg-24khz-16bit-mono-opus
     */
    Ogg24Khz16BitMonoOpus (19),

    /**
     * raw-48khz-16bit-mono-pcm
     */
    Raw48Khz16BitMonoPcm (20),

    /**
     * riff-48khz-16bit-mono-pcm
     */
    Riff48Khz16BitMonoPcm (21),

    /**
     * audio-48khz-96kbitrate-mono-mp3
     */
    Audio48Khz96KBitRateMonoMp3 (22),

    /**
     * audio-48khz-192kbitrate-mono-mp3
     */
    Audio48Khz192KBitRateMonoMp3 (23),

    /**
     * ogg-48khz-16bit-mono-opus
     * Added in version 1.16.0
     */
    Ogg48Khz16BitMonoOpus (24),

    /**
     * webm-16khz-16bit-mono-opus
     * Added in version 1.16.0
     */
    Webm16Khz16BitMonoOpus (25),

    /**
     * webm-24khz-16bit-mono-opus
     * Added in version 1.16.0
     */
    Webm24Khz16BitMonoOpus (26),

    /**
     * raw-24khz-16bit-mono-truesilk
     * Added in version 1.17.0
     */
    Raw24Khz16BitMonoTrueSilk (27),

    /**
     * raw-8khz-8bit-mono-alaw
     * Added in version 1.17.0
     */
    Raw8Khz8BitMonoALaw (28),

    /**
     * riff-8khz-8bit-mono-alaw
     * Added in version 1.17.0
     */
    Riff8Khz8BitMonoALaw (29),

    /**
     * webm-24khz-16bit-24kbps-mono-opus
     * Audio compressed by OPUS codec in a WebM container, with bitrate of 24kbps, optimized for IoT scenario.
     * Added in version 1.19.0
     */
    Webm24Khz16Bit24KbpsMonoOpus (30),

    /**
     * audio-16khz-16bit-32kbps-mono-opus
     * Audio compressed by OPUS codec without container, with bitrate of 32kbps.
     * Added in version 1.20.0
     */
    Audio16Khz16Bit32KbpsMonoOpus (31),

    /**
     * audio-24khz-16bit-48kbps-mono-opus
     * Audio compressed by OPUS codec without container, with bitrate of 48kbps.
     * Added in version 1.20.0
     */
    Audio24Khz16Bit48KbpsMonoOpus (32),

    /**
     * audio-24khz-16bit-24kbps-mono-opus
     * Audio compressed by OPUS codec without container, with bitrate of 24kbps.
     * Added in version 1.20.0
     */
    Audio24Khz16Bit24KbpsMonoOpus (33),

    /**
     * raw-22050hz-16bit-mono-pcm
     * Raw PCM audio at 22050Hz sampling rate and 16-bit depth.
     * Added in 1.22.0
     */
    Raw22050Hz16BitMonoPcm (34),

    /**
     * riff-22050hz-16bit-mono-pcm
     * PCM audio at 22050Hz sampling rate and 16-bit depth, with RIFF header.
     * Added in 1.22.0
     */
    Riff22050Hz16BitMonoPcm (35),

    /**
     * raw-44100hz-16bit-mono-pcm
     * Raw PCM audio at 44100Hz sampling rate and 16-bit depth.
     * Added in 1.22.0
     */
    Raw44100Hz16BitMonoPcm (36),

    /**
     * riff-44100hz-16bit-mono-pcm
     * PCM audio at 44100Hz sampling rate and 16-bit depth, with RIFF header.
     * Added in 1.22.0
     */
    Riff44100Hz16BitMonoPcm (37),

    /**
     * amr-wb-16000hz
     * AMR-WB audio at 16kHz sampling rate.
     * Added in 1.24.0
     */
    AmrWb16000Hz (38);

    private SpeechSynthesisOutputFormat(int id) {
        this.id = id;
    }

    /**
     * Returns the internal value format id
     *
     * @return the speech synthesis output format id
     */
    public int getValue() { return this.id; }

    private final int id;
}
