/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.transcription.Conversation;
import com.microsoft.cognitiveservices.speech.transcription.ConversationExpirationEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationParticipantsChangedEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslationCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslationEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class ConversationTranslator
implements AutoCloseable {
    protected AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<ConversationTranslationCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationExpirationEventArgs> conversationExpiration = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationParticipantsChangedEventArgs> participantsChanged = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> textMessageReceived = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> transcribed = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> transcribing = new EventHandlerImpl(this.eventCounter);
    static Set<ConversationTranslator> conversationTranslatorObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle translatorHandle = null;
    private final Object translatorLock = new Object();
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;
    private int activeAsyncRecognitionCounter = 0;
    private AudioConfig audioInputKeepAlive = null;

    public ConversationTranslator() {
        this(null);
    }

    public ConversationTranslator(AudioConfig audioConfig) {
        this.translatorHandle = new SafeHandle(0L, SafeHandleType.ConversationTranslator);
        this.audioInputKeepAlive = audioConfig;
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranslatorFromConfig(this.translatorHandle, null));
        } else {
            Contracts.throwIfFail(this.createConversationTranslatorFromConfig(this.translatorHandle, audioConfig.getImpl()));
        }
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public Future<Void> joinConversationAsync(Conversation conversation, final String string) {
        final ConversationTranslator conversationTranslator = this;
        final Conversation conversation2 = conversation;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.joinConversation(ConversationTranslator.this.translatorHandle, conversation2.getImpl(), string));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> joinConversationAsync(final String string, final String string2, final String string3) {
        final ConversationTranslator conversationTranslator = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.joinConversationId(ConversationTranslator.this.translatorHandle, string, string2, string3));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> leaveConversationAsync() {
        final ConversationTranslator conversationTranslator = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.leaveConversation(ConversationTranslator.this.translatorHandle));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> sendTextMessageAsync(final String string) {
        final ConversationTranslator conversationTranslator = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.sendText(ConversationTranslator.this.translatorHandle, string));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startTranscribingAsync() {
        final ConversationTranslator conversationTranslator = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.startTranscribing(ConversationTranslator.this.translatorHandle));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopTranscribingAsync() {
        final ConversationTranslator conversationTranslator = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(conversationTranslator.stopTranscribing(ConversationTranslator.this.translatorHandle));
                    }
                };
                conversationTranslator.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public void setAuthorizationToken(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "authToken");
        Contracts.throwIfNullOrWhitespace(string2, "region");
        Contracts.throwIfFail(this.setAuthToken(this.translatorHandle, string, string2));
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.translatorLock;
        synchronized (object) {
            if (this.activeAsyncRecognitionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a conversationTranslator while async transcription is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.translatorHandle;
    }

    private void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.translatorHandle != null) {
                this.translatorHandle.close();
                this.translatorHandle = null;
            }
            conversationTranslatorObjects.remove(this);
            this.audioInputKeepAlive = null;
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncRecognitionAction(Runnable runnable) {
        Object object = this.translatorLock;
        synchronized (object) {
            ++this.activeAsyncRecognitionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.translatorLock;
            synchronized (object) {
                --this.activeAsyncRecognitionCounter;
            }
        }
    }

    private void initialize() {
        final ConversationTranslator conversationTranslator = this;
        AsyncThreadService.initialize();
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.sessionStartedSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.sessionStoppedSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.canceledSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.conversationExpiration.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.conversationExpireSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.participantsChanged.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.participantsChangedSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.transcribing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.transcribingSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.transcribed.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.transcribedSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        this.textMessageReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(conversationTranslator);
                Contracts.throwIfFail(ConversationTranslator.this.textMessageSetCallback(conversationTranslator.translatorHandle.getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromHandle(conversationTranslator.translatorHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void sessionStartedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStarted;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStoppedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStopped;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationCanceledEventArgs conversationTranslationCanceledEventArgs = new ConversationTranslationCanceledEventArgs(l, true);
            EventHandlerImpl<ConversationTranslationCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranslationCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void participantsChangedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationParticipantsChangedEventArgs conversationParticipantsChangedEventArgs = new ConversationParticipantsChangedEventArgs(l, true);
            EventHandlerImpl<ConversationParticipantsChangedEventArgs> eventHandlerImpl = this.participantsChanged;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationParticipantsChangedEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void conversationExpireEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationExpirationEventArgs conversationExpirationEventArgs = new ConversationExpirationEventArgs(l, true);
            EventHandlerImpl<ConversationExpirationEventArgs> eventHandlerImpl = this.conversationExpiration;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationExpirationEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transcribingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs conversationTranslationEventArgs = new ConversationTranslationEventArgs(l, true);
            EventHandlerImpl<ConversationTranslationEventArgs> eventHandlerImpl = this.transcribing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranslationEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transcribedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs conversationTranslationEventArgs = new ConversationTranslationEventArgs(l, true);
            EventHandlerImpl<ConversationTranslationEventArgs> eventHandlerImpl = this.transcribed;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranslationEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void textMessageEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs conversationTranslationEventArgs = new ConversationTranslationEventArgs(l, true);
            EventHandlerImpl<ConversationTranslationEventArgs> eventHandlerImpl = this.textMessageReceived;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, conversationTranslationEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createConversationTranslatorFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long getPropertyBagFromHandle(SafeHandle var1, IntRef var2);

    private final native long sessionStartedSetCallback(long var1);

    private final native long sessionStoppedSetCallback(long var1);

    private final native long participantsChangedSetCallback(long var1);

    private final native long transcribingSetCallback(long var1);

    private final native long transcribedSetCallback(long var1);

    private final native long textMessageSetCallback(long var1);

    private final native long conversationExpireSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long joinConversation(SafeHandle var1, SafeHandle var2, String var3);

    private final native long joinConversationId(SafeHandle var1, String var2, String var3, String var4);

    private final native long leaveConversation(SafeHandle var1);

    private final native long sendText(SafeHandle var1, String var2);

    private final native long startTranscribing(SafeHandle var1);

    private final native long stopTranscribing(SafeHandle var1);

    private final native long setAuthToken(SafeHandle var1, String var2, String var3);
}

