/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.audio.PushAudioInputStream;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class AudioInputStream
implements AutoCloseable {
    protected SafeHandle streamHandle = null;

    public static PushAudioInputStream createPushStream() {
        return PushAudioInputStream.create();
    }

    public static PushAudioInputStream createPushStream(AudioStreamFormat audioStreamFormat) {
        return PushAudioInputStream.create(audioStreamFormat);
    }

    public static PullAudioInputStream createPullStream(PullAudioInputStreamCallback pullAudioInputStreamCallback) {
        return PullAudioInputStream.create(pullAudioInputStreamCallback);
    }

    public static PullAudioInputStream createPullStream(PullAudioInputStreamCallback pullAudioInputStreamCallback, AudioStreamFormat audioStreamFormat) {
        return PullAudioInputStream.create(pullAudioInputStreamCallback, audioStreamFormat);
    }

    @Override
    public void close() {
        if (this.streamHandle != null) {
            this.streamHandle.close();
            this.streamHandle = null;
        }
    }

    protected AudioInputStream(SafeHandle safeHandle) {
        Contracts.throwIfNull(safeHandle, "stream");
        this.streamHandle = safeHandle;
    }

    public SafeHandle getImpl() {
        return this.streamHandle;
    }

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

