/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class PronunciationAssessmentResult {
    private double accuracyScore;
    private double pronunciationScore;
    private double completenessScore;
    private double fluencyScore;

    public static PronunciationAssessmentResult fromResult(SpeechRecognitionResult speechRecognitionResult) {
        Contracts.throwIfNull(speechRecognitionResult, "speechRecognitionResult cannot be null");
        if (speechRecognitionResult.getProperties().getProperty("AccuracyScore").isEmpty()) {
            return null;
        }
        return new PronunciationAssessmentResult(speechRecognitionResult.getProperties());
    }

    public Double getAccuracyScore() {
        return this.accuracyScore;
    }

    public Double getPronunciationScore() {
        return this.pronunciationScore;
    }

    public Double getCompletenessScore() {
        return this.completenessScore;
    }

    public Double getFluencyScore() {
        return this.fluencyScore;
    }

    private PronunciationAssessmentResult(PropertyCollection propertyCollection) {
        this.accuracyScore = Double.parseDouble(propertyCollection.getProperty("AccuracyScore"));
        this.pronunciationScore = Double.parseDouble(propertyCollection.getProperty("PronScore"));
        this.completenessScore = Double.parseDouble(propertyCollection.getProperty("CompletenessScore"));
        this.fluencyScore = Double.parseDouble(propertyCollection.getProperty("FluencyScore"));
    }
}

