/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class Grammar
implements AutoCloseable {
    private SafeHandle grammarHandle = null;
    private boolean disposed = false;

    public static Grammar fromStorageId(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(Grammar.fromStorageId(intRef, string));
        return new Grammar(intRef.getValue());
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    public SafeHandle getImpl() {
        return this.grammarHandle;
    }

    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl && this.grammarHandle != null) {
            this.grammarHandle.close();
            this.grammarHandle = null;
        }
        this.disposed = true;
    }

    protected Grammar(long l) {
        Contracts.throwIfNull(l, "grammarHandleValue");
        this.grammarHandle = new SafeHandle(l, SafeHandleType.Grammar);
    }

    private static final native long fromStorageId(IntRef var0, String var1);
}

