/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ConnectionMessage;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class ConnectionMessageEventArgs {
    private ConnectionMessage message;

    protected ConnectionMessageEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs is null");
        SafeHandle safeHandle = null;
        safeHandle = new SafeHandle(l, SafeHandleType.ConnectionMessageEvent);
        Contracts.throwIfNull(safeHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getConnectionMessage(safeHandle, intRef));
        this.message = new ConnectionMessage(intRef.getValue());
        safeHandle.close();
        safeHandle = null;
    }

    public ConnectionMessage getMessage() {
        return this.message;
    }

    public String toString() {
        return "Message: " + this.getMessage().toString();
    }

    private final native long getConnectionMessage(SafeHandle var1, IntRef var2);
}

