/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.skills;

import com.microsoft.bot.builder.Storage;
import com.microsoft.bot.builder.skills.SkillConversationIdFactoryBase;
import com.microsoft.bot.builder.skills.SkillConversationIdFactoryOptions;
import com.microsoft.bot.builder.skills.SkillConversationReference;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.ConversationReference;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class SkillConversationIdFactory
extends SkillConversationIdFactoryBase {
    private Storage storage;

    public SkillConversationIdFactory(Storage storage) {
        if (storage == null) {
            throw new IllegalArgumentException("Storage cannot be null.");
        }
        this.storage = storage;
    }

    @Override
    public CompletableFuture<String> createSkillConversationId(SkillConversationIdFactoryOptions options) {
        if (options == null) {
            Async.completeExceptionally((Throwable)new IllegalArgumentException("options cannot be null."));
        }
        ConversationReference conversationReference = options.getActivity().getConversationReference();
        String skillConversationId = UUID.randomUUID().toString();
        SkillConversationReference skillConversationReference = new SkillConversationReference();
        skillConversationReference.setConversationReference(conversationReference);
        skillConversationReference.setOAuthScope(options.getFromBotOAuthScope());
        HashMap<String, Object> skillConversationInfo = new HashMap<String, Object>();
        skillConversationInfo.put(skillConversationId, skillConversationReference);
        return this.storage.write(skillConversationInfo).thenCompose(result -> CompletableFuture.completedFuture(skillConversationId));
    }

    @Override
    public CompletableFuture<SkillConversationReference> getSkillConversationReference(String skillConversationId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{skillConversationId})) {
            Async.completeExceptionally((Throwable)new IllegalArgumentException("skillConversationId cannot be null."));
        }
        return this.storage.read(new String[]{skillConversationId}).thenCompose(skillConversationInfo -> {
            if (skillConversationInfo.size() > 0) {
                return CompletableFuture.completedFuture((SkillConversationReference)skillConversationInfo.get(skillConversationId));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> deleteConversationReference(String skillConversationId) {
        return this.storage.delete(new String[]{skillConversationId});
    }
}

