/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.Storage;
import com.microsoft.bot.builder.StoreItem;
import com.microsoft.bot.connector.Async;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStorage
implements Storage {
    private static final String TYPENAMEFORNONENTITY = "__type_name_";
    private final Object syncroot = new Object();
    private ObjectMapper objectMapper;
    private Map<String, JsonNode> memory;
    private Logger logger = LoggerFactory.getLogger(MemoryStorage.class);
    private int eTag = 0;

    public MemoryStorage() {
        this(null);
    }

    public MemoryStorage(Map<String, JsonNode> values) {
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).findAndRegisterModules();
        this.objectMapper.enableDefaultTyping();
        this.memory = values != null ? values : new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Map<String, Object>> read(String[] keys) {
        if (keys == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("keys cannot be null"));
        }
        ConcurrentHashMap<String, Object> storeItems = new ConcurrentHashMap<String, Object>(keys.length);
        Object object = this.syncroot;
        synchronized (object) {
            for (String key : keys) {
                JsonNode stateNode;
                if (!this.memory.containsKey(key) || (stateNode = this.memory.get(key)) == null) continue;
                try {
                    Class<?> cls;
                    if (!stateNode.hasNonNull(TYPENAMEFORNONENTITY)) {
                        this.logger.error("Read failed: Type info not present for " + key);
                        return Async.completeExceptionally((Throwable)new RuntimeException(String.format("Read failed: Type info not present for key " + key, new Object[0])));
                    }
                    String clsName = stateNode.get(TYPENAMEFORNONENTITY).textValue();
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error("Read failed: Could not load class {}", (Object)clsName);
                        return Async.completeExceptionally((Throwable)new RuntimeException(String.format("Read failed: Could not load class %s", clsName)));
                    }
                    storeItems.put(key, this.objectMapper.treeToValue((TreeNode)stateNode, cls));
                }
                catch (JsonProcessingException e) {
                    this.logger.error("Read failed: {}", (Object)e.toString());
                    return Async.completeExceptionally((Throwable)new RuntimeException(String.format("Read failed: %s", e.toString())));
                }
            }
        }
        return CompletableFuture.completedFuture(storeItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> write(Map<String, Object> changes) {
        Object object = this.syncroot;
        synchronized (object) {
            for (Map.Entry<String, Object> change : changes.entrySet()) {
                JsonNode oldState;
                Object newValue = change.getValue();
                String oldStateETag = null;
                if (this.memory.containsKey(change.getKey()) && (oldState = this.memory.get(change.getKey())).has("eTag")) {
                    JsonNode eTagToken = oldState.get("eTag");
                    oldStateETag = eTagToken.asText();
                }
                JsonNode newState = this.objectMapper.valueToTree(newValue);
                ((ObjectNode)newState).put(TYPENAMEFORNONENTITY, newValue.getClass().getTypeName());
                if (newValue instanceof StoreItem) {
                    int newTag;
                    StoreItem newStoreItem = (StoreItem)newValue;
                    if (oldStateETag != null && !StringUtils.equals((CharSequence)newStoreItem.getETag(), (CharSequence)"*") && !StringUtils.equals((CharSequence)newStoreItem.getETag(), (CharSequence)oldStateETag)) {
                        String msg = String.format("eTag conflict. Original: %s, Current: %s", newStoreItem.getETag(), oldStateETag);
                        this.logger.error(msg);
                        return Async.completeExceptionally((Throwable)new RuntimeException(msg));
                    }
                    ++this.eTag;
                    ((ObjectNode)newState).put("eTag", Integer.toString(newTag));
                }
                this.memory.put(change.getKey(), newState);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> delete(String[] keys) {
        if (keys == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("keys cannot be null"));
        }
        Object object = this.syncroot;
        synchronized (object) {
            for (String key : keys) {
                this.memory.remove(key);
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

