/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.BotState;
import com.microsoft.bot.builder.TurnContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class BotStateSet {
    private List<BotState> botStates = new ArrayList<BotState>();

    public BotStateSet(BotState ... withBotStates) {
        this(Arrays.asList(withBotStates));
    }

    public BotStateSet(List<BotState> withBotStates) {
        this.botStates.addAll(withBotStates);
    }

    public List<BotState> getBotStates() {
        return this.botStates;
    }

    public void setBotStates(List<BotState> withBotState) {
        this.botStates = withBotState;
    }

    public BotStateSet add(BotState botState) {
        if (botState == null) {
            throw new IllegalArgumentException("botState");
        }
        this.botStates.add(botState);
        return this;
    }

    public CompletableFuture<Void> loadAll(TurnContext turnContext) {
        return this.loadAll(turnContext, false);
    }

    public CompletableFuture<Void> loadAll(TurnContext turnContext, boolean force) {
        return CompletableFuture.allOf((CompletableFuture[])this.botStates.stream().map(future -> future.load(turnContext, force)).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> saveAllChanges(TurnContext turnContext) {
        return this.saveAllChanges(turnContext, false);
    }

    public CompletableFuture<Void> saveAllChanges(TurnContext turnContext, boolean force) {
        CompletableFuture[] allSaves = (CompletableFuture[])this.botStates.stream().map(botState -> botState.saveChanges(turnContext, force)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(allSaves);
    }
}

