/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.builder.InvokeResponse;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.AdaptiveCardInvokeResponse;
import com.microsoft.bot.schema.AdaptiveCardInvokeValue;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.Error;
import com.microsoft.bot.schema.MessageReaction;
import com.microsoft.bot.schema.Serialization;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class ActivityHandler
implements Bot {
    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext cannot be null."));
        }
        if (turnContext.getActivity() == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("turnContext must have a non-null Activity."));
        }
        if (turnContext.getActivity().getType() == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("turnContext.getActivity must have a non-null Type."));
        }
        switch (turnContext.getActivity().getType()) {
            case "message": {
                return this.onMessageActivity(turnContext);
            }
            case "conversationUpdate": {
                return this.onConversationUpdateActivity(turnContext);
            }
            case "messageReaction": {
                return this.onMessageReactionActivity(turnContext);
            }
            case "event": {
                return this.onEventActivity(turnContext);
            }
            case "installationUpdate": {
                return this.onInstallationUpdate(turnContext);
            }
            case "command": {
                return this.onCommandActivity(turnContext);
            }
            case "commandResult": {
                return this.onCommandResultActivity(turnContext);
            }
            case "endOfConversation": {
                return this.onEndOfConversationActivity(turnContext);
            }
            case "typing": {
                return this.onTypingActivity(turnContext);
            }
            case "invoke": {
                return ((CompletableFuture)this.onInvokeActivity(turnContext).thenCompose(invokeResponse -> {
                    if (invokeResponse != null && turnContext.getTurnState().get("BotFrameworkAdapter.InvokeResponse") == null) {
                        Activity activity = new Activity("invokeResponse");
                        activity.setValue(invokeResponse);
                        return turnContext.sendActivity(activity);
                    }
                    CompletableFuture<Object> noAction = new CompletableFuture<Object>();
                    noAction.complete(null);
                    return noAction;
                })).thenApply(response -> null);
            }
        }
        return this.onUnrecognizedActivityType(turnContext);
    }

    protected CompletableFuture<Void> onMessageActivity(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onConversationUpdateActivity(TurnContext turnContext) {
        Activity activity = turnContext.getActivity();
        if (activity.getMembersAdded() != null && activity.getRecipient() != null && activity.getMembersAdded().stream().anyMatch(m -> !StringUtils.equals((CharSequence)m.getId(), (CharSequence)activity.getRecipient().getId()))) {
            return this.onMembersAdded(activity.getMembersAdded(), turnContext);
        }
        if (activity.getMembersRemoved() != null && activity.getRecipient() != null && activity.getMembersRemoved().stream().anyMatch(m -> !StringUtils.equals((CharSequence)m.getId(), (CharSequence)activity.getRecipient().getId()))) {
            return this.onMembersRemoved(activity.getMembersRemoved(), turnContext);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onMembersAdded(List<ChannelAccount> membersAdded, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onMembersRemoved(List<ChannelAccount> membersRemoved, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onMessageReactionActivity(TurnContext turnContext) {
        CompletableFuture<Void> task = null;
        if (turnContext.getActivity().getReactionsAdded() != null) {
            task = this.onReactionsAdded(turnContext.getActivity().getReactionsAdded(), turnContext);
        }
        if (turnContext.getActivity().getReactionsRemoved() != null) {
            if (task != null) {
                task.thenApply(result -> this.onReactionsRemoved(turnContext.getActivity().getReactionsRemoved(), turnContext));
            } else {
                task = this.onReactionsRemoved(turnContext.getActivity().getReactionsRemoved(), turnContext);
            }
        }
        return task == null ? CompletableFuture.completedFuture(null) : task;
    }

    protected CompletableFuture<Void> onReactionsAdded(List<MessageReaction> messageReactions, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onReactionsRemoved(List<MessageReaction> messageReactions, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onEventActivity(TurnContext turnContext) {
        if (StringUtils.equals((CharSequence)turnContext.getActivity().getName(), (CharSequence)"tokens/response")) {
            return this.onTokenResponseEvent(turnContext);
        }
        return this.onEvent(turnContext);
    }

    protected CompletableFuture<InvokeResponse> onInvokeActivity(TurnContext turnContext) {
        if (StringUtils.equals((CharSequence)turnContext.getActivity().getName(), (CharSequence)"adaptiveCard/action")) {
            AdaptiveCardInvokeValue invokeValue = null;
            try {
                invokeValue = this.getAdaptiveCardInvokeValue(turnContext.getActivity());
            }
            catch (InvokeResponseException e) {
                return Async.completeExceptionally((Throwable)e);
            }
            return this.onAdaptiveCardInvoke(turnContext, invokeValue).thenApply(result -> this.createInvokeResponse(result));
        }
        if (StringUtils.equals((CharSequence)turnContext.getActivity().getName(), (CharSequence)"signin/verifyState") || StringUtils.equals((CharSequence)turnContext.getActivity().getName(), (CharSequence)"signin/tokenExchange")) {
            return ((CompletableFuture)this.onSignInInvoke(turnContext).thenApply(aVoid -> this.createInvokeResponse(null))).exceptionally(ex -> {
                if (ex instanceof CompletionException && ex.getCause() instanceof InvokeResponseException) {
                    InvokeResponseException ire = (InvokeResponseException)ex.getCause();
                    return new InvokeResponse(ire.statusCode, ire.body);
                }
                if (ex instanceof InvokeResponseException) {
                    InvokeResponseException ire = (InvokeResponseException)ex;
                    return new InvokeResponse(ire.statusCode, ire.body);
                }
                return new InvokeResponse(500, null);
            });
        }
        CompletableFuture<InvokeResponse> result2 = new CompletableFuture<InvokeResponse>();
        result2.complete(new InvokeResponse(501, null));
        return result2;
    }

    protected CompletableFuture<Void> onSignInInvoke(TurnContext turnContext) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        result.completeExceptionally(new InvokeResponseException(501));
        return result;
    }

    protected InvokeResponse createInvokeResponse(Object body) {
        return new InvokeResponse(200, body);
    }

    protected CompletableFuture<Void> onTokenResponseEvent(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onEvent(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onInstallationUpdate(TurnContext turnContext) {
        String action = turnContext.getActivity().getAction();
        if (StringUtils.isEmpty((CharSequence)action)) {
            return CompletableFuture.completedFuture(null);
        }
        switch (action) {
            case "add": 
            case "add-upgrade": {
                return this.onInstallationUpdateAdd(turnContext);
            }
            case "remove": 
            case "remove-upgrade": {
                return this.onInstallationUpdateRemove(turnContext);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onCommandActivity(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onCommandResultActivity(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onInstallationUpdateAdd(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onInstallationUpdateRemove(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<AdaptiveCardInvokeResponse> onAdaptiveCardInvoke(TurnContext turnContext, AdaptiveCardInvokeValue invokeValue) {
        return Async.completeExceptionally((Throwable)new InvokeResponseException(501));
    }

    protected CompletableFuture<Void> onEndOfConversationActivity(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTypingActivity(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onUnrecognizedActivityType(TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    private AdaptiveCardInvokeValue getAdaptiveCardInvokeValue(Activity activity) throws InvokeResponseException {
        if (activity.getValue() == null) {
            AdaptiveCardInvokeResponse response = this.createAdaptiveCardInvokeErrorResponse(400, "BadRequest", "Missing value property");
            throw new InvokeResponseException(400, response);
        }
        AdaptiveCardInvokeValue invokeValue = (AdaptiveCardInvokeValue)Serialization.getAs((Object)activity.getValue(), AdaptiveCardInvokeValue.class);
        if (invokeValue == null) {
            AdaptiveCardInvokeResponse response = this.createAdaptiveCardInvokeErrorResponse(400, "BadRequest", "Value property instanceof not properly formed");
            throw new InvokeResponseException(400, response);
        }
        if (invokeValue.getAction() == null) {
            AdaptiveCardInvokeResponse response = this.createAdaptiveCardInvokeErrorResponse(400, "BadRequest", "Missing action property");
            throw new InvokeResponseException(400, response);
        }
        if (!invokeValue.getAction().getType().equals("Action.Execute")) {
            AdaptiveCardInvokeResponse response = this.createAdaptiveCardInvokeErrorResponse(400, "NotSupported", String.format("The action '%s'is not supported.", invokeValue.getAction().getType()));
            throw new InvokeResponseException(400, response);
        }
        return invokeValue;
    }

    private AdaptiveCardInvokeResponse createAdaptiveCardInvokeErrorResponse(Integer statusCode, String code, String message) {
        AdaptiveCardInvokeResponse adaptiveCardInvokeResponse = new AdaptiveCardInvokeResponse();
        adaptiveCardInvokeResponse.setStatusCode(statusCode.intValue());
        adaptiveCardInvokeResponse.setType("application/vnd.getmicrosoft().error");
        Error error = new Error();
        error.setCode(code);
        error.setMessage(message);
        adaptiveCardInvokeResponse.setValue((Object)error);
        return adaptiveCardInvokeResponse;
    }

    protected class InvokeResponseException
    extends Exception {
        private int statusCode;
        private Object body;

        public InvokeResponseException(int withStatusCode) {
            this(withStatusCode, null);
        }

        public InvokeResponseException(int withStatusCode, Object withBody) {
            this.statusCode = withStatusCode;
            this.body = withBody;
        }

        public InvokeResponse createInvokeResponse() {
            return new InvokeResponse(this.statusCode, this.body);
        }
    }
}

