/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.bulk.entities.BulkAgeTarget;
import com.microsoft.bingads.bulk.entities.BulkAgeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkDayTimeTarget;
import com.microsoft.bingads.bulk.entities.BulkDayTimeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkDeviceOsTarget;
import com.microsoft.bingads.bulk.entities.BulkDeviceOsTargetBid;
import com.microsoft.bingads.bulk.entities.BulkEntity;
import com.microsoft.bingads.bulk.entities.BulkGenderTarget;
import com.microsoft.bingads.bulk.entities.BulkGenderTargetBid;
import com.microsoft.bingads.bulk.entities.BulkLocationTarget;
import com.microsoft.bingads.bulk.entities.BulkLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkNegativeLocationTarget;
import com.microsoft.bingads.bulk.entities.BulkNegativeLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkRadiusTarget;
import com.microsoft.bingads.bulk.entities.BulkRadiusTargetBid;
import com.microsoft.bingads.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.bulk.entities.BulkTargetWithLocation;
import com.microsoft.bingads.bulk.entities.Status;
import com.microsoft.bingads.campaignmanagement.LocationTarget2;
import com.microsoft.bingads.campaignmanagement.Target2;
import com.microsoft.bingads.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.internal.bulk.TryResult;
import com.microsoft.bingads.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import com.microsoft.bingads.internal.utilities.Comparer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

abstract class BulkTarget<TIdentifier extends BulkTargetIdentifier, TAgeBid extends BulkAgeTargetBid, TAge extends BulkAgeTarget<TAgeBid>, TDayTimeBid extends BulkDayTimeTargetBid, TDayTime extends BulkDayTimeTarget<TDayTimeBid>, TDeviceOsBid extends BulkDeviceOsTargetBid, TDeviceOs extends BulkDeviceOsTarget<TDeviceOsBid>, TGenderBid extends BulkGenderTargetBid, TGender extends BulkGenderTarget<TGenderBid>, TLocationBid extends BulkLocationTargetBid, TLocation extends BulkLocationTarget<TLocationBid>, TNegativeLocationBid extends BulkNegativeLocationTargetBid, TNegativeLocation extends BulkNegativeLocationTarget<TNegativeLocationBid>, TRadiusTargetBid extends BulkRadiusTargetBid, TRadius extends BulkRadiusTarget<TRadiusTargetBid>>
extends MultiRecordBulkEntity {
    private Status status;
    private Long entityId;
    private String entityName;
    private String parentEntityName;
    private Target2 target;
    private TAge ageTarget;
    private Class<TAgeBid> classOfTAgeBid;
    private TDayTime dayTimeTarget;
    private Class<TDayTimeBid> classOfTDayTimeBid;
    private TDeviceOs deviceOsTarget;
    private Class<TDeviceOsBid> classOfTDeviceOsBid;
    private TGender genderTarget;
    private Class<TGenderBid> classOfTGenderBid;
    private TLocation locationTarget;
    private Class<TLocationBid> classOfTLocationBid;
    private TNegativeLocation negativeLocationTarget;
    private Class<TNegativeLocationBid> classOfTNegativeLocationBid;
    private TRadius radiusTarget;
    private Class<TRadiusTargetBid> classOfTRadiusBid;
    private TIdentifier originalIdentifier;
    private Class<TIdentifier> classOfTIdentifier;
    private final List<BulkTargetBid> bids = new ArrayList<BulkTargetBid>();
    private final List<TIdentifier> deleteAllRows = new ArrayList<TIdentifier>();

    protected BulkTarget(BulkTargetBid bid, TAge age, Class<TAgeBid> classOfTAgeBid, TDayTime dayTime, Class<TDayTimeBid> classOfTDayTimeBid, TDeviceOs deviceOs, Class<TDeviceOsBid> classOfTDeviceOsBid, TGender gender, Class<TGenderBid> classOfTGenderBid, TLocation location, Class<TLocationBid> classOfTLocationBid, TNegativeLocation negativeLocation, Class<TNegativeLocationBid> classOfTNegativeLocationBid, TRadius radius, Class<TRadiusTargetBid> classOfTRadiusBid, Class<TIdentifier> classOfTIdentifier) {
        this(bid.getIdentifier(), age, classOfTAgeBid, dayTime, classOfTDayTimeBid, deviceOs, classOfTDeviceOsBid, gender, classOfTGenderBid, location, classOfTLocationBid, negativeLocation, classOfTNegativeLocationBid, radius, classOfTRadiusBid, classOfTIdentifier);
        this.bids.add(bid);
    }

    protected BulkTarget(TIdentifier identifier, TAge age, Class<TAgeBid> classOfTAgeBid, TDayTime dayTime, Class<TDayTimeBid> classOfTDayTimeBid, TDeviceOs deviceOs, Class<TDeviceOsBid> classOfTDeviceOsBid, TGender gender, Class<TGenderBid> classOfTGenderBid, TLocation location, Class<TLocationBid> classOfTLocationBid, TNegativeLocation negativeLocation, Class<TNegativeLocationBid> classOfTNegativeLocationBid, TRadius radiusTarget, Class<TRadiusTargetBid> classOfTRadiusBid, Class<TIdentifier> classOfTIdentifier) {
        this(age, classOfTAgeBid, dayTime, classOfTDayTimeBid, deviceOs, classOfTDeviceOsBid, gender, classOfTGenderBid, location, classOfTLocationBid, negativeLocation, classOfTNegativeLocationBid, radiusTarget, classOfTRadiusBid);
        this.setTarget(new Target2());
        this.getTarget().setId(((BulkTargetIdentifier)identifier).getTargetId());
        this.setEntityId(((BulkTargetIdentifier)identifier).getEntityId());
        this.setEntityName(((BulkTargetIdentifier)identifier).getEntityName());
        this.setParentEntityName(((BulkTargetIdentifier)identifier).getParentEntityName());
        if (((BulkTargetIdentifier)identifier).isDeleteRow()) {
            this.deleteAllRows.add(identifier);
        }
        this.originalIdentifier = identifier;
        this.classOfTIdentifier = classOfTIdentifier;
    }

    protected BulkTarget(TAge age, Class<TAgeBid> classOfTAgeBid, TDayTime dayTime, Class<TDayTimeBid> classOfTDayTimeBid, TDeviceOs deviceOs, Class<TDeviceOsBid> classOfTDeviceOsBid, TGender gender, Class<TGenderBid> classOfTGenderBid, TLocation location, Class<TLocationBid> classOfTLocationBid, TNegativeLocation negativeLocation, Class<TNegativeLocationBid> classOfTNegativeLocationBid, TRadius radiusTarget, Class<TRadiusTargetBid> classOfTRadiusBid) {
        this.setAgeTarget(age);
        this.setDayTime(dayTime);
        this.setDeviceOs(deviceOs);
        this.setGender(gender);
        this.setLocationTarget(location);
        this.setNegativeLocationTarget(negativeLocation);
        this.setRadiusTarget(radiusTarget);
        this.classOfTAgeBid = classOfTAgeBid;
        this.classOfTDayTimeBid = classOfTDayTimeBid;
        this.classOfTDeviceOsBid = classOfTDeviceOsBid;
        this.classOfTGenderBid = classOfTGenderBid;
        this.classOfTLocationBid = classOfTLocationBid;
        this.classOfTNegativeLocationBid = classOfTNegativeLocationBid;
        this.classOfTRadiusBid = classOfTRadiusBid;
    }

    @Override
    public void writeToStream(BulkObjectWriter rowWriter) throws IOException {
        if (this.getStatus() != Status.DELETED) {
            this.validatePropertyNotNull(this.getTarget(), "Target");
        }
        if (this.getTarget() != null && this.getTarget().getAge() == null) {
            throw new IllegalStateException("At least one sub target must not be null.");
        }
        if (this.getTarget() != null) {
            ((BulkAgeTarget)this.getAgeTarget()).setAgeTarget(this.getTarget().getAge());
            ((BulkDayTimeTarget)this.getDayTimeTarget()).setDayTimeTarget(this.getTarget().getDayTime());
            ((BulkDeviceOsTarget)this.getDeviceOsTarget()).setDeviceOsTarget(this.getTarget().getDeviceOS());
            ((BulkGenderTarget)this.getGenderTarget()).setGenderTarget(this.getTarget().getGender());
            ((BulkTargetWithLocation)this.getLocationTarget()).setLocation(this.getTarget().getLocation());
            ((BulkTargetWithLocation)this.getNegativeLocationTarget()).setLocation(this.getTarget().getLocation());
            ((BulkTargetWithLocation)this.getRadiusTarget()).setLocation(this.getTarget().getLocation());
        }
        this.setDefaultIdentifier((BulkSubTarget)this.getAgeTarget(), (Class)this.classOfTAgeBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getDayTimeTarget(), (Class)this.classOfTDayTimeBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getDeviceOsTarget(), (Class)this.classOfTDeviceOsBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getGenderTarget(), (Class)this.classOfTGenderBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getLocationTarget(), (Class)this.classOfTLocationBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getNegativeLocationTarget(), (Class)this.classOfTNegativeLocationBid);
        this.setDefaultIdentifier((BulkSubTarget)this.getRadiusTarget(), (Class)this.classOfTRadiusBid);
        ((BulkAgeTarget)this.getAgeTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkDayTimeTarget)this.getDayTimeTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkDeviceOsTarget)this.getDeviceOsTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkGenderTarget)this.getGenderTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkLocationTarget)this.getLocationTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkNegativeLocationTarget)this.getNegativeLocationTarget()).isBeingWrittenAsPartOfParentTarget = true;
        ((BulkRadiusTarget)this.getRadiusTarget()).isBeingWrittenAsPartOfParentTarget = true;
        for (BulkEntity childEntity : this.getSubTargets()) {
            childEntity.writeToStream(rowWriter);
        }
    }

    @Override
    public void readRelatedDataFromStream(BulkStreamReader reader) {
        if (this.classOfTIdentifier == null) {
            throw new InternalException(new IllegalStateException("Can't read a target that has been initialized manually"));
        }
        boolean hasMoreRows = true;
        while (hasMoreRows) {
            TryResult<BulkTargetBid> nextBulkTargetBidResult = reader.tryRead(new Predicate<BulkTargetBid>(){

                @Override
                public boolean test(BulkTargetBid x) {
                    return BulkTarget.this.originalIdentifier.equals(x.getIdentifier());
                }
            }, BulkTargetBid.class);
            if (nextBulkTargetBidResult.isSuccessful()) {
                BulkTargetBid nextBid = nextBulkTargetBidResult.getResult();
                this.bids.add(nextBid);
                if (this.getTarget().getId() != null || nextBid.getTargetId() == null) continue;
                this.getTarget().setId(nextBid.getTargetId());
                continue;
            }
            TryResult<TIdentifier> identifierResult = reader.tryRead(new Predicate<TIdentifier>(){

                @Override
                public boolean test(TIdentifier x) {
                    return Comparer.compareNullable(((BulkTargetIdentifier)x).getEntityId(), BulkTarget.this.getEntityId()) != false && ((BulkTargetIdentifier)x).isDeleteRow();
                }
            }, this.classOfTIdentifier);
            if (identifierResult.isSuccessful()) {
                this.deleteAllRows.add(identifierResult.getResult());
                continue;
            }
            hasMoreRows = false;
        }
        this.setStatus(this.bids.size() > 0 ? Status.ACTIVE : Status.DELETED);
        LocationTarget2 location = new LocationTarget2();
        ((BulkTargetWithLocation)this.getLocationTarget()).setLocation(location);
        ((BulkTargetWithLocation)this.getNegativeLocationTarget()).setLocation(location);
        ((BulkTargetWithLocation)this.getRadiusTarget()).setLocation(location);
        HashMap<Class, List<BulkTargetBid>> bidGroups = this.groupBidsByType();
        this.populateChildTargetBids((BulkSubTarget)this.getAgeTarget(), bidGroups, this.classOfTAgeBid);
        this.populateChildTargetBids((BulkSubTarget)this.getDayTimeTarget(), bidGroups, this.classOfTDayTimeBid);
        this.populateChildTargetBids((BulkSubTarget)this.getDeviceOsTarget(), bidGroups, this.classOfTDeviceOsBid);
        this.populateChildTargetBids((BulkSubTarget)this.getGenderTarget(), bidGroups, this.classOfTGenderBid);
        this.populateChildTargetBids((BulkSubTarget)this.getLocationTarget(), bidGroups, this.classOfTLocationBid);
        this.populateChildTargetBids((BulkSubTarget)this.getNegativeLocationTarget(), bidGroups, this.classOfTNegativeLocationBid);
        this.populateChildTargetBids((BulkSubTarget)this.getRadiusTarget(), bidGroups, this.classOfTRadiusBid);
        HashMap<Class, List<TIdentifier>> deleteAllGroups = this.groupDeleteAllRowsByType();
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getAgeTarget(), deleteAllGroups, this.classOfTAgeBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getDayTimeTarget(), deleteAllGroups, this.classOfTDayTimeBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getDeviceOsTarget(), deleteAllGroups, this.classOfTDeviceOsBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getGenderTarget(), deleteAllGroups, this.classOfTGenderBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getLocationTarget(), deleteAllGroups, this.classOfTLocationBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getNegativeLocationTarget(), deleteAllGroups, this.classOfTNegativeLocationBid);
        this.populateChildTargetIdentifiers((BulkSubTarget)this.getRadiusTarget(), deleteAllGroups, this.classOfTRadiusBid);
        if (location.getCityTarget() != null || location.getMetroAreaTarget() != null || location.getStateTarget() != null || location.getCountryTarget() != null || location.getPostalCodeTarget() != null || location.getRadiusTarget() != null) {
            this.getTarget().setLocation(location);
        }
        this.getTarget().setAge(((BulkAgeTarget)this.getAgeTarget()).getAgeTarget());
        this.getTarget().setDayTime(((BulkDayTimeTarget)this.getDayTimeTarget()).getDayTimeTarget());
        this.getTarget().setDeviceOS(((BulkDeviceOsTarget)this.getDeviceOsTarget()).getDeviceOsTarget());
        this.getTarget().setGender(((BulkGenderTarget)this.getGenderTarget()).getGenderTarget());
    }

    private HashMap<Class, List<TIdentifier>> groupDeleteAllRowsByType() {
        HashMap<Class, List<TIdentifier>> deleteAllGroups = new HashMap<Class, List<TIdentifier>>();
        for (BulkTargetIdentifier identifier : this.deleteAllRows) {
            List<TIdentifier> identifiersForBidType = deleteAllGroups.get(identifier.getTargetBidType());
            if (identifiersForBidType == null) {
                identifiersForBidType = new ArrayList<TIdentifier>();
                deleteAllGroups.put(identifier.getTargetBidType(), identifiersForBidType);
            }
            identifiersForBidType.add(identifier);
        }
        return deleteAllGroups;
    }

    private HashMap<Class, List<BulkTargetBid>> groupBidsByType() {
        HashMap<Class, List<BulkTargetBid>> bidGroups = new HashMap<Class, List<BulkTargetBid>>();
        for (BulkTargetBid bid : this.bids) {
            List<BulkTargetBid> bidsForType = bidGroups.get(bid.getClass());
            if (bidsForType == null) {
                bidsForType = new ArrayList<BulkTargetBid>();
                bidGroups.put(bid.getClass(), bidsForType);
            }
            bidsForType.add(bid);
        }
        return bidGroups;
    }

    private <T extends BulkTargetBid> void populateChildTargetBids(BulkSubTarget<T> target, HashMap<Class, List<BulkTargetBid>> groups, Class<T> classOfT) {
        if (!groups.containsKey(classOfT)) {
            target.setStatus(Status.DELETED);
            return;
        }
        List<BulkTargetBid> bidsForTarget = groups.get(classOfT);
        ArrayList<BulkTargetBid> bidsForTargetAsT = new ArrayList<BulkTargetBid>();
        for (BulkTargetBid bid : bidsForTarget) {
            bidsForTargetAsT.add(bid);
        }
        target.setBids(bidsForTargetAsT);
    }

    private <T extends BulkTargetBid> void populateChildTargetIdentifiers(BulkSubTarget<T> target, HashMap<Class, List<TIdentifier>> groups, Class<T> classOfT) {
        if (!groups.containsKey(classOfT)) {
            this.setDefaultIdentifier(target, classOfT);
            return;
        }
        List<TIdentifier> identifiers = groups.get(classOfT);
        for (BulkTargetIdentifier identifier : identifiers) {
            target.setIdentifier(identifier);
        }
    }

    public List<BulkEntity> getSubTargets() {
        return Collections.unmodifiableList(Arrays.asList(this.getAgeTarget(), this.getDayTimeTarget(), this.getDeviceOsTarget(), this.getGenderTarget(), this.getLocationTarget(), this.getNegativeLocationTarget(), this.getRadiusTarget()));
    }

    @Override
    public List<? extends BulkEntity> getChildEntities() {
        return this.getSubTargets();
    }

    @Override
    public boolean allChildrenPresent() {
        for (BulkEntity child : this.getSubTargets()) {
            if (((MultiRecordBulkEntity)child).allChildrenPresent()) continue;
            return false;
        }
        return true;
    }

    abstract TIdentifier createIdentifier(Class var1);

    private <TBid extends BulkTargetBid> void setDefaultIdentifier(BulkSubTarget<TBid> target, Class<TBid> classOfTBid) {
        TIdentifier identifier = this.createIdentifier(classOfTBid);
        ((BulkTargetIdentifier)identifier).setEntityId(this.getEntityId());
        if (this.getTarget() != null) {
            ((BulkTargetIdentifier)identifier).setTargetId(this.getTarget().getId());
        }
        ((BulkTargetIdentifier)identifier).setEntityName(this.getEntityName());
        ((BulkTargetIdentifier)identifier).setParentEntityName(this.getParentEntityName());
        if (this.getStatus() == Status.DELETED) {
            target.setStatus(Status.DELETED);
        }
        target.setIdentifier((BulkTargetIdentifier)identifier);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    protected Long getEntityId() {
        return this.entityId;
    }

    protected void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    protected String getEntityName() {
        return this.entityName;
    }

    protected void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    protected String getParentEntityName() {
        return this.parentEntityName;
    }

    protected void setParentEntityName(String parentEntityName) {
        this.parentEntityName = parentEntityName;
    }

    public Target2 getTarget() {
        return this.target;
    }

    public void setTarget(Target2 target) {
        this.target = target;
    }

    public TAge getAgeTarget() {
        return this.ageTarget;
    }

    public void setAgeTarget(TAge ageTarget) {
        this.ageTarget = ageTarget;
    }

    public TDayTime getDayTimeTarget() {
        return this.dayTimeTarget;
    }

    public void setDayTime(TDayTime dayTimeTarget) {
        this.dayTimeTarget = dayTimeTarget;
    }

    public TDeviceOs getDeviceOsTarget() {
        return this.deviceOsTarget;
    }

    public void setDeviceOs(TDeviceOs deviceOsTarget) {
        this.deviceOsTarget = deviceOsTarget;
    }

    public TGender getGenderTarget() {
        return this.genderTarget;
    }

    public void setGender(TGender genderTarget) {
        this.genderTarget = genderTarget;
    }

    public TLocation getLocationTarget() {
        return this.locationTarget;
    }

    public void setLocationTarget(TLocation locationTarget) {
        this.locationTarget = locationTarget;
    }

    public TNegativeLocation getNegativeLocationTarget() {
        return this.negativeLocationTarget;
    }

    public void setNegativeLocationTarget(TNegativeLocation negativeLocationTarget) {
        this.negativeLocationTarget = negativeLocationTarget;
    }

    public TRadius getRadiusTarget() {
        return this.radiusTarget;
    }

    public void setRadiusTarget(TRadius radiusTarvet) {
        this.radiusTarget = radiusTarvet;
    }
}

