/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkAd;
import com.microsoft.bingads.campaignmanagement.AdType;
import com.microsoft.bingads.campaignmanagement.MobileAd;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkMobileAd
extends BulkAd<MobileAd> {
    private static final List<BulkMapping<BulkMobileAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values) {
        this.validatePropertyNotNull(this.getMobileAd(), "MobileAd");
        super.processMappingsToRowValues(values);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new MobileAd());
        ((MobileAd)this.getAd()).setType(AdType.MOBILE);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public MobileAd getMobileAd() {
        return (MobileAd)this.ad;
    }

    public void setMobileAd(MobileAd mobileAd) {
        this.setAd(mobileAd);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkMobileAd, String>> m = new ArrayList<SimpleBulkMapping<BulkMobileAd, String>>();
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Title", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getTitle();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setTitle(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Text", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Display Url", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getDisplayUrl();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setDisplayUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Destination Url", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getDestinationUrl();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setDestinationUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Business Name", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getBusinessName();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setBusinessName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkMobileAd, String>("Phone Number", new Function<BulkMobileAd, String>(){

            @Override
            public String apply(BulkMobileAd c) {
                return ((MobileAd)c.getAd()).getPhoneNumber();
            }
        }, new BiConsumer<String, BulkMobileAd>(){

            @Override
            public void accept(String v, BulkMobileAd c) {
                ((MobileAd)c.getAd()).setPhoneNumber(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

