/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.PerformanceData;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.BulkObject;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkKeywordBidSuggestion
extends BulkObject {
    private String keywordText;
    private Double bid;
    private PerformanceData performanceData = new PerformanceData();
    private static List<BulkMapping<BulkKeywordBidSuggestion>> MAPPINGS;

    @Override
    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData.readFromRowValues(values);
    }

    public String getKeywordText() {
        return this.keywordText;
    }

    public Double getBid() {
        return this.bid;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    private void setKeywordText(String keywordText) {
        this.keywordText = keywordText;
    }

    private void setBid(Double bid) {
        this.bid = bid;
    }

    private void setPerformanceData(PerformanceData performanceData) {
        this.performanceData = performanceData;
    }

    static {
        ArrayList m = new ArrayList();
        m.add(new SimpleBulkMapping("Keyword", new BiConsumer<String, BulkKeywordBidSuggestion>(){

            @Override
            public void accept(String v, BulkKeywordBidSuggestion c) {
                c.setKeywordText(v);
            }
        }));
        m.add(new SimpleBulkMapping("Bid", new BiConsumer<String, BulkKeywordBidSuggestion>(){

            @Override
            public void accept(String v, BulkKeywordBidSuggestion c) {
                c.setBid(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

