/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkEntity;
import com.microsoft.bingads.bulk.entities.BulkError;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.TryResult;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public abstract class SingleRecordBulkEntity
extends BulkEntity {
    private String clientId;
    private Calendar lastModifiedTime;
    private List<BulkError> errors;
    private static List<BulkMapping<SingleRecordBulkEntity>> MAPPINGS;

    @Override
    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.processMappingsFromRowValues(values);
    }

    public abstract void processMappingsFromRowValues(RowValues var1);

    @Override
    public void writeToRowValues(RowValues values) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        this.processMappingsToRowValues(values);
    }

    public abstract void processMappingsToRowValues(RowValues var1);

    @Override
    public final void readRelatedDataFromStream(BulkStreamReader reader) {
        this.readAdditionalData(reader);
        this.readErrors(reader);
    }

    public void readAdditionalData(BulkStreamReader reader) {
    }

    private void readErrors(BulkStreamReader reader) {
        ArrayList<BulkError> errors = new ArrayList<BulkError>();
        TryResult<BulkError> errorResult = reader.tryRead(BulkError.class);
        while (errorResult.isSuccessful()) {
            errors.add(errorResult.getResult());
            errorResult = reader.tryRead(BulkError.class);
        }
        this.errors = errors;
    }

    @Override
    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    @Override
    public void writeToStream(BulkObjectWriter rowWriter) throws IOException {
        rowWriter.writeObjectRow(this);
    }

    @Override
    public Calendar getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<BulkError> getErrors() {
        return this.errors;
    }

    static {
        ArrayList<SimpleBulkMapping<SingleRecordBulkEntity, String>> m = new ArrayList<SimpleBulkMapping<SingleRecordBulkEntity, String>>();
        m.add(new SimpleBulkMapping<SingleRecordBulkEntity, String>("Client Id", new Function<SingleRecordBulkEntity, String>(){

            @Override
            public String apply(SingleRecordBulkEntity c) {
                return c.getClientId();
            }
        }, new BiConsumer<String, SingleRecordBulkEntity>(){

            @Override
            public void accept(String v, SingleRecordBulkEntity c) {
                c.setClientId(v);
            }
        }));
        m.add(new SimpleBulkMapping("Modified Time", new BiConsumer<String, SingleRecordBulkEntity>(){

            @Override
            public void accept(String v, SingleRecordBulkEntity c) {
                c.lastModifiedTime = StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                });
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

