/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PerformanceData {
    private Double spend;
    private Integer impressions;
    private Integer clicks;
    private Double clickThroughRate;
    private Double averageCostPerClick;
    private Double averageCostPerThousandImpressions;
    private Double averagePosition;
    private Integer conversions;
    private Double costPerConversion;
    private static final List<BulkMapping<PerformanceData>> MAPPINGS;

    public static PerformanceData readFromRowValuesOrNull(RowValues values) {
        PerformanceData performanceData = new PerformanceData();
        performanceData.readFromRowValues(values);
        return performanceData.hasAnyValues() ? performanceData : null;
    }

    public Double getSpend() {
        return this.spend;
    }

    public Integer getImpressions() {
        return this.impressions;
    }

    public Integer getClicks() {
        return this.clicks;
    }

    public Double getClickThroughRate() {
        return this.clickThroughRate;
    }

    public Double getAverageCostPerClick() {
        return this.averageCostPerClick;
    }

    public Double getAverageCostPerThousandImpressions() {
        return this.averageCostPerThousandImpressions;
    }

    public Double getAveragePosition() {
        return this.averagePosition;
    }

    public Integer getConversions() {
        return this.conversions;
    }

    public Double getCostPerConversion() {
        return this.costPerConversion;
    }

    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    private boolean hasAnyValues() {
        return this.spend != null || this.impressions != null || this.clicks != null || this.clickThroughRate != null || this.averageCostPerClick != null || this.averageCostPerThousandImpressions != null || this.averagePosition != null || this.conversions != null || this.costPerConversion != null;
    }

    private void setSpend(Double spend) {
        this.spend = spend;
    }

    private void setImpressions(Integer impressions) {
        this.impressions = impressions;
    }

    private void setClicks(Integer clicks) {
        this.clicks = clicks;
    }

    private void setClickThroughRate(Double clickThroughRate) {
        this.clickThroughRate = clickThroughRate;
    }

    private void setAverageCostPerClick(Double averageCostPerClick) {
        this.averageCostPerClick = averageCostPerClick;
    }

    private void setAverageCostPerThousandImpressions(Double averageCostPerThousandImpressions) {
        this.averageCostPerThousandImpressions = averageCostPerThousandImpressions;
    }

    private void setAveragePosition(Double averagePosition) {
        this.averagePosition = averagePosition;
    }

    private void setConversions(Integer conversions) {
        this.conversions = conversions;
    }

    private void setCostPerConversion(Double costPerConversion) {
        this.costPerConversion = costPerConversion;
    }

    static {
        ArrayList m = new ArrayList();
        m.add(new SimpleBulkMapping("Spend", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setSpend(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping("Impressions", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setImpressions(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("Clicks", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setClicks(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("CTR", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setClickThroughRate(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping("Avg CPC", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAverageCostPerClick(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping("Avg CPM", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAverageCostPerThousandImpressions(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping("Avg position", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setAveragePosition(StringExtensions.nullOrDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping("Conversions", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setConversions(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("CPA", new BiConsumer<String, PerformanceData>(){

            @Override
            public void accept(String v, PerformanceData d) {
                d.setCostPerConversion(StringExtensions.nullOrDouble(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

