/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkRadiusTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetWithLocation;
import com.microsoft.bingads.campaignmanagement.ArrayOfRadiusTargetBid2;
import com.microsoft.bingads.campaignmanagement.IntentOption;
import com.microsoft.bingads.campaignmanagement.LocationTarget2;
import com.microsoft.bingads.campaignmanagement.RadiusTarget2;
import com.microsoft.bingads.campaignmanagement.RadiusTargetBid2;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import java.util.ArrayList;
import java.util.List;

abstract class BulkRadiusTarget<TBid extends BulkRadiusTargetBid>
extends BulkTargetWithLocation<TBid> {
    public BulkRadiusTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.reconstructApiBids(this.getBids(), new Function<TBid, RadiusTargetBid2>(){

            @Override
            public RadiusTargetBid2 apply(TBid t) {
                return ((BulkRadiusTargetBid)t).getRadiusTargetBid();
            }
        }, new Supplier<RadiusTarget2>(){

            @Override
            public RadiusTarget2 get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget();
            }
        }, new Supplier<RadiusTarget2>(){

            @Override
            public RadiusTarget2 get() {
                return new RadiusTarget2();
            }
        }, new Consumer<RadiusTarget2>(){

            @Override
            public void accept(RadiusTarget2 t) {
                BulkRadiusTarget.this.getLocation().setRadiusTarget(t);
            }
        }, new Supplier<List<RadiusTargetBid2>>(){

            @Override
            public List<RadiusTargetBid2> get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget().getBids().getRadiusTargetBid2s();
            }
        }, new Consumer<List<RadiusTargetBid2>>(){

            @Override
            public void accept(List<RadiusTargetBid2> t) {
                BulkRadiusTarget.this.getLocation().getRadiusTarget().setBids(new ArrayOfRadiusTargetBid2());
                BulkRadiusTarget.this.getLocation().getRadiusTarget().getBids().getRadiusTargetBid2s().addAll(t);
            }
        });
        if (!this.getBids().isEmpty()) {
            this.getLocation().setIntentOption(((BulkRadiusTargetBid)this.getBids().get(0)).getIntentOption());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList bulkBids = new ArrayList();
        this.convertBidsFromApi(bulkBids, new Supplier<RadiusTarget2>(){

            @Override
            public RadiusTarget2 get() {
                return BulkRadiusTarget.this.getLocation().getRadiusTarget();
            }
        }, new Function<RadiusTarget2, List<RadiusTargetBid2>>(){

            @Override
            public List<RadiusTargetBid2> apply(RadiusTarget2 t) {
                return t.getBids().getRadiusTargetBid2s();
            }
        }, new BiConsumer<TBid, RadiusTargetBid2>(){

            @Override
            public void accept(TBid t, RadiusTargetBid2 u) {
                ((BulkRadiusTargetBid)t).setRadiusTargetBid(u);
            }
        }, new Function<RadiusTargetBid2, Boolean>(){

            @Override
            public Boolean apply(RadiusTargetBid2 t) {
                return true;
            }
        });
        for (BulkRadiusTargetBid bid : bulkBids) {
            bid.setIntentOption(this.getLocation().getIntentOption());
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getRadiusTarget(), "RadiusTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getRadiusTarget() != null) {
            this.validateListNotNullOrEmpty(this.getRadiusTarget().getBids(), this.getRadiusTarget().getBids().getRadiusTargetBid2s(), "RadiusTarget.Bids");
        }
    }

    public RadiusTarget2 getRadiusTarget() {
        return this.getLocationProperty(new Function<LocationTarget2, RadiusTarget2>(){

            @Override
            public RadiusTarget2 apply(LocationTarget2 t) {
                return t.getRadiusTarget();
            }
        });
    }

    public void setRadiusTarget(final RadiusTarget2 radiusTarget) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setRadiusTarget(radiusTarget);
            }
        });
    }

    public IntentOption getIntentOption() {
        return this.getLocationProperty(new Function<LocationTarget2, IntentOption>(){

            @Override
            public IntentOption apply(LocationTarget2 t) {
                return t.getIntentOption();
            }
        });
    }

    public void setIntentOption(final IntentOption intentOption) {
        this.setLocationProperty(new Consumer<LocationTarget2>(){

            @Override
            public void accept(LocationTarget2 t) {
                t.setIntentOption(intentOption);
            }
        });
    }
}

