/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdGroupNegativeCriterion
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupNegativeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        Criterion criterion = this.createCriterion();
        adGroupCriterion.setCriterion(criterion);
        adGroupCriterion.getCriterion().setType(criterion.getClass().getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    protected abstract Criterion createCriterion();

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), NegativeAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion negativeAdGroupCriterion) {
        this.negativeAdGroupCriterion = negativeAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeCriterion, String>("Status", new Function<BulkAdGroupNegativeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeCriterion c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeCriterion c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeCriterion, Long>("Id", new Function<BulkAdGroupNegativeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeCriterion c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeCriterion c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeCriterion, Long>("Parent Id", new Function<BulkAdGroupNegativeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeCriterion c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeCriterion c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeCriterion, String>("Campaign", new Function<BulkAdGroupNegativeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeCriterion, String>("Ad Group", new Function<BulkAdGroupNegativeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

